package report

import (
	"context"
	"github.com/zeromicro/go-zero/core/logx"
	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"
)

type InformToWriteTodayReportLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewInformToWriteTodayReportLogic(ctx context.Context, svcCtx *svc.ServiceContext) *InformToWriteTodayReportLogic {
	return &InformToWriteTodayReportLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *InformToWriteTodayReportLogic) InformToWriteTodayReport(req *types.InformToWriteTodayReportReq) (resp *types.InformToWriteTodayReportResp, err error) {
	_, err = l.svcCtx.ReportRpc.InformToWriteTodayReport(l.ctx, &oa.InformToWriteTodayReportReq{
		UserEmails:   req.UserEmails,
		SingedInUser: l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string),
		ReportDate:   req.ReportDate,
	})
	if err != nil {
		logx.Errorw("failed to call reportrpc.InformToWriteTodayReport", logx.Field("error", err))
		return nil, err
	}
	return &types.InformToWriteTodayReportResp{}, nil
}
