package report

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type ListDepartmentReportsLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewListDepartmentReportsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListDepartmentReportsLogic {
	return &ListDepartmentReportsLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *ListDepartmentReportsLogic) ListDepartmentReports(req *types.ListDepartmentReportsReq) (resp *types.ListDepartmentReportsResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)
	in := &oa.ListDepartmentReportsReq{
		UserEmail:     user.Email,
		DepartmentKey: req.DepartmentKey,
		ReportType:    oa.ReportType(req.ReportType),
		ReportDate:    req.ReportDate,
		ReportStatus:  oa.ReportStatus(req.ReportStatus),
		IsDelayed:     req.IsDelayed,
		HasRisk:       req.HasRisk,
	}

	out, err := l.svcCtx.ReportRpc.ListDepartmentReports(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call ReportRpc.ListDepartmentReports", logx.Field("error", err))
		return nil, err
	}

	list := make([]types.Report, len(out.List))
	for i, v := range out.GetList() {
		items := make([]types.ReportItem, len(v.ReportItemList))
		for j, m := range v.ReportItemList {
			items[j] = types.ReportItem{
				ReportItemId: m.GetReportItemId(),
				Content:      m.GetContent(),
			}
		}

		rpt := types.Report{
			UserEmail:      v.UserEmail,
			ReportId:       v.ReportId,
			ReportType:     int32(v.ReportType),
			ReportDate:     v.ReportDate,
			ReportStatus:   int32(v.ReportStatus),
			IsDelayed:      v.IsDelayed,
			DelayReason:    v.DelayReason,
			HasRisk:        v.HasRisk,
			RiskDesc:       v.RiskDesc,
			CreatedAt:      v.CreatedAt,
			UpdatedAt:      v.UpdatedAt,
			ReportItemList: items,
		}

		if v.GetDepartment() != nil {
			rpt.Department = types.Department{
				DepartmentKey:  v.GetDepartment().GetKey(),
				DepartmentName: v.GetDepartment().GetName(),
			}
		}

		list[i] = rpt
	}

	resp = &types.ListDepartmentReportsResp{List: list}
	return
}
