package report

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type ListReportDelayAndRiskLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewListReportDelayAndRiskLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListReportDelayAndRiskLogic {
	return &ListReportDelayAndRiskLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *ListReportDelayAndRiskLogic) ListReportDelayAndRisk(req *types.ListReportDelayAndRiskReq) (resp *types.ListReportDelayAndRiskResp, err error) {
	in := &oa.ListReportDelayAndRiskReq{
		DepartmentKey:   req.DepartmentKey,
		ReportStartDate: req.ReportStartDate,
		ReportEndDate:   req.ReportEndDate,
	}

	out, err := l.svcCtx.ReportRpc.ListReportDelayAndRisk(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call reportrpc.ListReportDelayAndRisk", logx.Field("error", err))
		return nil, err
	}

	return &types.ListReportDelayAndRiskResp{
		DelayRiskList:         out.DelayRiskList,
		ShowInformBtnUserList: out.ShowInformBtnUserList,
	}, nil
}
