package report

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type ListReportLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewListReportLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListReportLogic {
	return &ListReportLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *ListReportLogic) ListReport(req *types.ListReportReq) (resp *types.ListReportResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	in := &oa.ListReportReq{
		UserEmail:       user.Email,
		ReportStartDate: req.ReportStartDate,
		ReportEndDate:   req.ReportEndDate,
		TargetUserEmail: req.TargetUserEmail,
		PageNum:         req.PageNum,
		PageSize:        req.PageSize,
	}
	out, err := l.svcCtx.ReportRpc.ListReport(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call reportrpc.ListReport", logx.Field("error", err))
		return nil, err
	}

	return &types.ListReportResp{Total: uint64(out.GetTotal()), List: out.GetList()}, nil
}
