package report

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type ListReportMentionLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewListReportMentionLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListReportMentionLogic {
	return &ListReportMentionLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *ListReportMentionLogic) ListReportMention(req *types.ListReportMentionReq) (resp *types.ListReportMentionResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)
	in := &oa.ListReportMentionReq{
		UserEmail:       user.Email,
		ReportStartDate: req.ReportStartDate,
		ReportEndDate:   req.ReportEndDate,
		TargetUserEmail: req.TargetUserEmail,
	}

	out, err := l.svcCtx.ReportRpc.ListReportMention(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call reportrpc.ListReportMention", logx.Field("error", err))
		return nil, err
	}

	return &types.ListReportMentionResp{List: out.List}, nil
}
