package report

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateReportLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdateReportLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateReportLogic {
	return &UpdateReportLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateReportLogic) UpdateReport(req *types.UpdateReportReq) (resp *types.UpdateReportResp, err error) {
	user := ctxdata.GetUserInfoFromCtx(l.ctx)

	items := make([]*oa.ReportItemForModify, len(req.ReportItemList))
	for i, v := range req.ReportItemList {
		items[i] = &oa.ReportItemForModify{
			Content:     v.Content,
			MentionList: v.MentionList,
		}
	}
	in := &oa.UpdateReportReq{
		UserEmail:      user.Email,
		ReportId:       req.ReportID,
		ReportItemList: items,
		IsDelayed:      req.IsDelayed,
		DelayReason:    req.DelayReason,
		HasRisk:        req.HasRisk,
		RiskDesc:       req.RiskDesc,
		IsDraft:        req.IsDraft,
	}

	_, err = l.svcCtx.ReportRpc.UpdateReport(l.ctx, in)
	if err != nil {
		logx.Errorw("failed to call reportrpc.UpdateReport", logx.Field("error", err))
		return nil, err
	}

	return &types.UpdateReportResp{}, nil
}
