package user

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type DepartmentListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDepartmentListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DepartmentListLogic {
	return &DepartmentListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DepartmentListLogic) DepartmentList(req *types.DepartmentListReq) (resp *types.PageResult, err error) {
	list, err := l.svcCtx.UserRpc.DepartmentList(l.ctx, &oa.DepartmentListReq{
		Valid:    req.Valid,
		Employee: req.Employee,
	})
	if err != nil {
		return nil, err
	}

	return &types.PageResult{
		List:  list.List,
		Total: list.Total,
	}, nil
}
