package user

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/client/userrpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type DepartmentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDepartmentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DepartmentLogic {
	return &DepartmentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DepartmentLogic) Department(req *types.DepartmentReq) (resp *types.PageResult, err error) {
	department, err := l.svcCtx.UserRpc.Department(l.ctx, &userrpc.DepartmentReq{
		DepartmentKey: req.DepartmentKey,
		Type:          req.Type,
	})
	if err != nil {
		return nil, err
	}
	return &types.PageResult{
		List:  department.List,
		Total: department.Total,
	}, nil

}
