package user

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type DepartmentUserListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDepartmentUserListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DepartmentUserListLogic {
	return &DepartmentUserListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DepartmentUserListLogic) DepartmentUserList(req *types.DepartmentUserListReq) (resp *types.DepartmentUserListResp, err error) {
	out, err := l.svcCtx.UserRpc.GetDepartmentUserList(l.ctx, &oa.GetDepartmentUserListReq{DepartmentKeyList: req.DepartmentKeyList})
	if err != nil {
		logx.Errorw("failed to call UserRpc.GetDepartmentUserList", logx.Field("error", err))
		return nil, err
	}

	return &types.DepartmentUserListResp{List: out.DepartmentUserList}, nil
}
