package user

import (
	"context"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/ctxdata"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetUserFollowerLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetUserFollowerLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetUserFollowerLogic {
	return &GetUserFollowerLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetUserFollowerLogic) GetUserFollower() (resp *types.PageResult, err error) {
	userEmail := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	in := &oa.GetUserFollowerReq{UserEmail: userEmail}
	out, err := l.svcCtx.UserRpc.GetUserFollower(l.ctx, in)
	if err != nil {
		l.Logger.Errorw("failed to call userRpc.GetUserFollower", logx.Field("error", err))
		return nil, err
	}

	return &types.PageResult{Total: int64(out.Total), List: out.List}, nil
}
