package user

import (
	"context"
	"oa-server/app/oacenter/oa_rpc/oa"

	"oa-server/app/oacenter/oa_api/internal/svc"
	"oa-server/app/oacenter/oa_api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type UserListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUserListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UserListLogic {
	return &UserListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UserListLogic) UserList(req *types.UserListReq) (resp *types.PageResult, err error) {
	rpcResp, err := l.svcCtx.UserRpc.UserList(l.ctx, &oa.UserListReq{
		DepartmentKeys: req.DepartmentKeys,
	})
	if err != nil {
		return nil, err
	}

	return &types.PageResult{
		List:  rpcResp.List,
		Total: rpcResp.Total,
	}, nil
}
