package svc

import (
	"oa-server/app/jobcenter/model"
	"oa-server/app/oacenter/oa_api/internal/config"
	"oa-server/app/oacenter/oa_rpc/client/calcrpc"
	"oa-server/app/oacenter/oa_rpc/client/issuerpc"
	"oa-server/app/oacenter/oa_rpc/client/monitorrpc"
	"oa-server/app/oacenter/oa_rpc/client/okrrpc"
	"oa-server/app/oacenter/oa_rpc/client/performancerpc"
	"oa-server/app/oacenter/oa_rpc/client/reportrpc"
	"oa-server/app/oacenter/oa_rpc/client/userrpc"
	"oa-server/app/usercenter/rpc/usercenterclient"
	"oa-server/common/middleware"

	"github.com/redis/go-redis/v9"

	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/rest"
	"github.com/zeromicro/go-zero/zrpc"
)

type ServiceContext struct {
	Config         config.Config
	AuthMiddleware rest.Middleware
	UserRpc        userrpc.UserRpc
	IssueRpc       issuerpc.IssueRpc
	MonitorRpc     monitorrpc.MonitorRpc
	UserCenterRpc  usercenterclient.Usercenter
	PerformanceRpc performancerpc.PerformanceRpc
	ReportRpc      reportrpc.ReportRpc
	LbkUcClient    *lbkUc.LbkUserClient
	CalcRpc        calcrpc.CalcRpc
	OkrRpc         okrrpc.OkrRpc
	UserCache      *model.UserCenterService
	RedisClient    *redis.Client
}

func NewServiceContext(c config.Config) *ServiceContext {
	lbkUcClient, _ := lbkUc.NewLbkUserClient(c.LbkUserCenter.Env, c.LbkUserCenter.HostInAli)

	svcCtx := &ServiceContext{
		Config: c,
		RedisClient: redis.NewClient(&redis.Options{
			Addr:     c.RedisConf.Host,
			Password: c.RedisConf.Pass,
		}),
		AuthMiddleware: middleware.NewAuthMiddleware(c.LbkUserCenter.AppName, lbkUcClient).Handle,
		UserRpc:        userrpc.NewUserRpc(zrpc.MustNewClient(c.OACenterRpcConf)),
		IssueRpc:       issuerpc.NewIssueRpc(zrpc.MustNewClient(c.OACenterRpcConf)),
		MonitorRpc:     monitorrpc.NewMonitorRpc(zrpc.MustNewClient(c.OACenterRpcConf)),
		PerformanceRpc: performancerpc.NewPerformanceRpc(zrpc.MustNewClient(c.OACenterRpcConf)),
		ReportRpc:      reportrpc.NewReportRpc(zrpc.MustNewClient(c.OACenterRpcConf)),
		LbkUcClient:    lbkUcClient,
		CalcRpc:        calcrpc.NewCalcRpc(zrpc.MustNewClient(c.OACenterRpcConf)),
		OkrRpc:         okrrpc.NewOkrRpc(zrpc.MustNewClient(c.OACenterRpcConf)),
	}
	svcCtx.UserCache = model.NewUserCenterService(svcCtx.RedisClient)
	return svcCtx
}
