// Code generated by goctl. DO NOT EDIT.
// goctl 1.8.1

package types

type AlignAddReq struct {
	EntityId          int64 `json:"entity_id"`
	AlignWithEntityId int64 `json:"align_with_entity_id"`
}

type AlignDelReq struct {
	EntityId          int64 `json:"entity_id"`
	AlignWithEntityId int64 `json:"align_with_entity_id"`
}

type AssignAddReq struct {
	EntityId      int64  `json:"entity_id"`
	IntendedOwner string `json:"intended_owner"`
}

type BasePaginationReq struct {
	Page     int `json:"page,optional,default=1"`
	PageSize int `json:"pageSize,optional,default=10"`
}

type BaseResp struct {
	Code int         `json:"code"`
	Msg  string      `json:"msg"`
	Data interface{} `json:"data,omitempty"`
}

type BugInfo struct {
	Reason   string `json:"reason"`
	Count    int64  `json:"count"`
	Type     string `json:"type"`
	Priority string `json:"priority"`
}

type CalcEnumResp struct {
	Role         []Item `json:"role"`
	Index        []Item `json:"index"`
	MonitorIndex []Item `json:"monitor_index"`
	IssueIndex   []Item `json:"issue_index"`
}

type CalcHistoryListData struct {
	ID             uint64 `json:"id"`
	DepartmentName string `json:"department_name"`
	UpdateTime     string `json:"update_time"`
	UpdateUser     string `json:"update_user"`
	EffectiveTime  string `json:"effective_time"`
	CalcFormula    []Item `json:"calc_formula"`
	RoleName       string `json:"role_name"`
	IndexName      string `json:"index_name"`
	Index          int    `json:"index"`
}

type CalcHistoryListReq struct {
	BasePaginationReq
	ID uint64 `json:"id"`
}

type CalcHistoryListResp struct {
	List  interface{} `json:"list"`
	Total int         `json:"total"`
}

type CalcListData struct {
	ID                   uint64 `json:"id"`
	DepartmentKey        string `json:"department"`
	DepartmentName       string `json:"department_name"`
	ParentDepartmentKey  string `json:"parent_department"`
	ParentDepartmentName string `json:"parent_department_name"`
	Role                 int    `json:"role"`
	RoleName             string `json:"role_name"`
	Index                int    `json:"index"`
	IndexName            string `json:"index_name"`
	CalcFormula          []Item `json:"calc_formula"`
	LastUpdateTime       string `json:"update_time"`
	LastUpdateUser       string `json:"update_user"`
}

type CalcListReq struct {
	BasePaginationReq
	DepartmentKey       string `json:"department_key,optional"`
	ParentDepartmentKey string `json:"parent_department_key,optional"`
	Role                int    `json:"role,optional"`
	Index               int    `json:"index,optional"`
}

type CalcListResp struct {
	List  interface{} `json:"list"`
	Total int         `json:"total"`
}

type ChartTypeEnum struct {
	ChartType int `json:"chart_type,options=0|1|2|3|4,optional"`
}

type Column struct {
	DataIndex string `json:"dataIndex"`
	Title     string `json:"title"`
	Align     string `json:"align,omitempty"`
}

type CreateIssueMetricsReq struct {
	PeriodType    int64      `json:"period_type"`
	Employee      string     `json:"employee"`
	DepartmentKey string     `json:"department_key"`
	DateFromTo    string     `json:"date_from_to"`
	Infos         IssueInfos `json:"infos"`
	ProjectKey    string     `json:"project_key"`
	Role          int8       `json:"role"`
}

type CreateKeyResultReq struct {
	OkrId       int64   `json:"okr_id"`
	ObjectiveId int64   `json:"objective_id"`
	UserEmail   string  `json:"user_email"`
	TypeForKR   int64   `json:"type_for_kr"`
	Content     string  `json:"content"`
	Weight      float64 `json:"weight"`
	Priority    int64   `json:"priority"`
	Deadline    string  `json:"deadline"`
}

type CreateKeyResultResp struct {
	KeyResultId int64 `json:"keyresult_id"`
}

type CreateMonitorMetricsReq struct {
	TotalEvents            int     `json:"total_events"`
	PeriodType             int     `json:"period_type"`
	Employee               string  `json:"employee"`
	DateFromTo             string  `json:"date_from_to"`
	FailureRecurrenceRate  float32 `json:"failure_recurrence_rate"`
	AverageProcessingTime  float32 `json:"average_processing_time"`
	AverageResolutionTime  float32 `json:"average_resolution_time"`
	EffectiveHandledEvents float32 `json:"effective_handled_events"`
	BizRuleHitRate         float32 `json:"biz_rule_hit_rate"`
	BizEventAssignmentRate float32 `json:"biz_event_assignment_rate"`
}

type CreateObjectiveReq struct {
	OkrId    uint64  `json:"okr_id"`
	Content  string  `json:"content"`
	Weight   float64 `json:"weight"`
	Priority int64   `json:"priority"`
	Deadline string  `json:"deadline"`
}

type CreateObjectiveResp struct {
	ObjectiveId uint64 `json:"objective_id"`
}

type CreateOkrReq struct {
	StartDate string `json:"start_date"`
	EndDate   string `json:"end_date"`
}

type CreateOkrResp struct {
	OkrID uint64 `json:"okr_id"`
}

type CreateOkrTaskReq struct {
	OkrId       uint64  `json:"okr_id"`
	ObjectiveId uint64  `json:"objective_id"`
	KeyResultId uint64  `json:"keyresult_id"`
	UserEmail   string  `json:"user_email"`
	Content     string  `json:"content"`
	Weight      float32 `json:"weight"`
	Priority    int64   `json:"priority"`
	Deadline    string  `json:"deadline"`
}

type CreatePerformanceItemCommentReq struct {
	PerformanceID uint64 `json:"performance_id"`
	ItemID        uint64 `json:"item_id"`
	CommentType   uint32 `json:"comment_type"`
	Comment       string `json:"comment"`
}

type CreatePerformanceItemCommentResp struct {
	CommentID uint64 `json:"comment_id"`
}

type CreatePerformanceReq struct {
	Year     uint64 `json:"year"`
	MonthNum uint64 `json:"month_num"`
}

type CreatePerformanceResp struct {
	ID uint64 `json:"id"`
}

type CreatePerformanceWorkItemReq struct {
	PerformanceID uint64  `json:"performance_id"`
	ItemName      string  `json:"item_name"`
	ItemWeight    float64 `json:"item_weight"`
	ItemDesc      string  `json:"item_desc"`
	ItemDeficency string  `json:"item_deficency"`
	SelfScore     float64 `json:"self_score"`
}

type CreatePerformanceWorkItemResp struct {
	ItemID uint64 `json:"item_id"`
}

type CreateReportCommentReq struct {
	ReportID uint64 `json:"report_id"`
	Content  string `json:"content"`
}

type CreateReportCommentResp struct {
	ReportCommentID uint64 `json:"report_comment_id"`
}

type CreateReportReq struct {
	ReportType     uint32       `json:"report_type"`
	ReportDate     string       `json:"report_date"`
	ReportItemList []ReportItem `json:"report_item_list"`
	IsDelayed      bool         `json:"is_delayed"`
	DelayReason    string       `json:"delay_reason,optional"`
	HasRisk        bool         `json:"has_risk"`
	RiskDesc       string       `json:"risk_desc,optional"`
	IsDraft        bool         `json:"is_draft"`
}

type CreateReportResp struct {
	ReportID uint64 `json:"report_id"`
}

type Data struct {
	ID              string         `json:"id"`
	Department      string         `json:"department"`
	NickName        string         `json:"nickname"`
	ProdBugCount    int            `json:"prodBugCount"`
	NonProdBugCount int            `json:"nonProdBugCount"`
	BugEscapeRate   string         `json:"bugEscapeRate"`
	Score           string         `json:"score"`
	Email           string         `json:"email"`
	ExpandedData    []ExpandedData `json:"expandedData"`
}

type DeleteKeyResultReq struct {
	OkrId       int64 `json:"okr_id"`
	ObjectiveId int64 `json:"objective_id"`
	KeyResultId int64 `json:"keyresult_id"`
}

type DeleteKeyResultResp struct {
}

type DeleteObjectiveReq struct {
	OkrId       uint64 `json:"okr_id"`
	ObjectiveId uint64 `json:"objective_id"`
}

type DeleteObjectiveResp struct {
}

type DeleteOkrTaskReq struct {
	OkrId       uint64 `json:"okr_id"`
	ObjectiveId uint64 `json:"objective_id"`
	KeyResultId uint64 `json:"keyresult_id"`
	TaskId      uint64 `json:"task_id"`
}

type DeletePerformanceItemCommentReq struct {
	PerformanceID uint64 `json:"performance_id"`
	CommentID     uint64 `json:"comment_id"`
}

type DeletePerformanceItemCommentResp struct {
}

type DeletePerformanceWorkItemReq struct {
	ItemID uint64 `json:"item_id"`
}

type DeletePerformanceWorkItemResp struct {
}

type Department struct {
	DepartmentKey  string `json:"department_key"`
	DepartmentName string `json:"department_name"`
}

type DepartmentInfo struct {
	Key    string `json:"key"`
	Name   string `json:"name"`
	Leader string `json:"leader"`
}

type DepartmentListReq struct {
	Valid    bool   `json:"valid,optional"`
	Employee string `json:"employee,optional"`
}

type DepartmentReq struct {
	DepartmentKey string `json:"department_key"`
	Type          string `json:"type,optional"`
}

type DepartmentStatistics struct {
	DepartmentKey     string                 `json:"department_key"`
	DepartmentName    string                 `json:"department_name"`
	ReportTypeToCount map[string]int32       `json:"report_type_to_count"`
	ReportDateToCount map[string]int32       `json:"report_date_to_count"`
	Individuals       []IndividualStatistics `json:"individuals"`
}

type DepartmentUser struct {
	DepartmentKey     string     `json:"department_key"`
	DepartmentName    string     `json:"department_name"`
	DepartmentLeaders []string   `json:"department_leaders"` // 部门领导email列表
	UserList          []UserInfo `json:"user_list"`
}

type DepartmentUserListReq struct {
	DepartmentKeyList []string `json:"department_key_list"`
}

type DepartmentUserListResp struct {
	List interface{} `json:"list"`
}

type Departments struct {
	Level3 []DepartmentStatistics `json:"level3"`
	Level4 []DepartmentStatistics `json:"level4"`
	Level5 []DepartmentStatistics `json:"level5"`
}

type EmptyResp struct {
}

type ExpandedData struct {
	Type     string `json:"type"`
	Count    int    `json:"count"`
	Reason   string `json:"reason"`
	Priority string `json:"priority"`
}

type FinishLeaderEvaluationReq struct {
	PerformanceID uint64 `json:"performance_id"`
}

type FinishLeaderEvaluationResp struct {
}

type FinishPerformanceWorkloadFillingReq struct {
	PerformanceID uint64 `json:"performance_id"`
}

type FinishPerformanceWorkloadFillingResp struct {
}

type GetOkrMenuDataReq struct {
	StartDate string `form:"start_date"`
	EndDate   string `form:"end_date"`
}

type GetOkrMenuDataResp struct {
	PeerColleagues     []UserInfo       `json:"peer_colleagues"`      // 相同上级的同事
	DepartmentUserList []DepartmentUser `json:"department_user_list"` // 管理部门-用户列表
}

type GetPerformanceAdditionScoreListReq struct {
	UserEmail     string `form:"user_email,optional"`
	Year          uint64 `form:"year,optional"`
	MonthNum      uint64 `form:"month_num,optional"`
	CoworkerEmail string `json:"coworker_email,optional"`
	PageNum       uint64 `form:"page_num,default=1"`
	PageSize      uint64 `form:"page_size,default=50,range=[1:999]"`
}

type GetPerformanceAdditionScoreListResp struct {
	Total uint64                     `json:"total"`
	List  []PerformanceAdditionScore `json:"scores"`
}

type GetPerformanceDetailReq struct {
	PerformanceID uint64 `form:"performance_id"`
}

type GetPerformanceDetailResp struct {
	Performance
	WorkItems     []PerformanceWorkItem     `json:"item_works"`
	AdditionItems []PerformanceAdditionItem `json:"addition_items"`
}

type GetPerformanceItemCommentListReq struct {
	PerformanceID uint64 `form:"performance_id"`
	ItemID        uint64 `form:"item_id"`
	CommentType   uint32 `form:"comment_type"`
}

type GetPerformanceItemCommentListResp struct {
	Total uint64                   `json:"total"`
	List  []PerformanceItemComment `json:"comments"`
}

type GetPerformanceMenuDataReq struct {
	Year     uint64 `form:"year"`
	MonthNum uint64 `form:"month_num"`
}

type GetPerformanceMenuDataResp struct {
	Followers          []UserInfo       `json:"followers"`            // 如果不是rocky，那么就是自己的下属
	DepartmentUserList []DepartmentUser `json:"department_user_list"` //如果是，列出下面的管理部门-用户列表
}

type GetPerformanceRankingReq struct {
	Year                uint64 `form:"year"`
	MonthNum            uint64 `form:"month_num"`
	UserEmail           string `form:"user_email,optional"`
	SortField           string `form:"sort_field,default=total_score,options=total_score|total_bonus"`
	SortOrder           string `form:"sort_order,default=desc,options=asc|desc"`
	PageNum             uint64 `form:"page_num,default=1"`
	PageSize            uint64 `form:"page_size,default=50,range=[1:999]"`
	DepartmentKey       string `form:"department_key,optional"`
	IsExcellentEmployee uint64 `form:"is_excellent_employee,optional"`
	Status              uint64 `form:"status,optional"`
}

type GetPerformanceRankingResp struct {
	Total      uint64               `json:"total"`
	TotalBonus float64              `json:"total_bonus"`
	List       []PerformanceRanking `json:"list"`
	Statistics []Statistics         `json:"statistics"`
}

type GetPerformanceReq struct {
	Year     uint64 `form:"year"`
	MonthNum uint64 `form:"month_num, optional"`
}

type GetPerformanceResp struct {
	List []Performance `json:"list"`
}

type GetStaffPerformanceListReq struct {
	Year     uint64 `form:"year"`
	MonthNum uint64 `form:"month_num"`
}

type GetStaffPerformanceListResp struct {
	List []Performance `json:"list"`
}

type GetStaffPerformanceReq struct {
	UserEmail string `form:"user_email"`
	Year      uint64 `form:"year"`
	MonthNum  uint64 `form:"month_num"`
}

type GetStaffPerformanceResp struct {
	List []Performance `json:"list"`
}

type HeatmapChartData struct {
	XAxis  []string    `json:"xAxis"`
	YAxis  []string    `json:"yAxis"`
	Series [][]float64 `json:"series"`
}

type IndividualStatistics struct {
	UserEmail         string           `json:"user_email"`
	ReportTypeToCount map[string]int32 `json:"report_type_to_count"`
	ReportDateToCount map[string]int32 `json:"report_date_to_count"`
}

type InformPerformanceReq struct {
	Year          uint64     `json:"year"`
	MonthNum      uint64     `json:"month_num"`
	DepartmentKey string     `json:"department_key,optional"`
	LarkUserList  []LarkUser `json:"lark_user_list,optional"`
}

type InformPerformanceResp struct {
}

type InformToWritePerformanceReq struct {
	UserEmails []string `json:"user_emails"`
	Year       uint64   `json:"year"`
	MonthNum   uint64   `json:"month_num"`
}

type InformToWritePerformanceResp struct {
}

type InformToWriteTodayReportReq struct {
	UserEmails []string `json:"user_emails"`
	ReportDate string   `json:"report_date,optional"`
}

type InformToWriteTodayReportResp struct {
}

type IssueInfo struct {
	Reason   string `json:"reason"`
	Count    int64  `json:"count"`
	Type     string `json:"type"`
	Priority string `json:"priority"`
}

type IssueInfos struct {
	Data []IssueInfo `json:"data"`
}

type IssueListReq struct {
	BasePaginationReq
	PeriodTypeEnum
	DepartmentKey string `json:"department_key"`
	DateFromTo    string `json:"date_from_to"`
	Employee      string `json:"employee,optional"`
}

type IssueListResp struct {
	Columns         []Column `json:"columns"`
	ExpandedColumns []Column `json:"expandedColumns"`
	Data            []Data   `json:"data"`
	Total           int64    `json:"total"`
}

type IssuePersonalMetricsReq struct {
	PeriodType int    `json:"period_type"`       // 周期类型
	DateFromTo string `json:"date_from_to"`      // 日期范围
	Employee   string `json:"employee,optional"` // 可选的员工标识
}

type IssuePersonalMetricsResp struct {
	Id            int64          `json:"id"`
	ProdBug       MetricItemData `json:"prod_bug"`        // 生产bug
	NonProdBug    MetricItemData `json:"non_prod_bug"`    // 非生产bug
	BugEscapeRate MetricItemData `json:"bug_escape_rate"` // bug 逃逸率
	ScoreInfo     ScoreInfo      `json:"score_info"`
	Nickname      string         `json:"nickname"`
}

type Item struct {
	Key   interface{} `json:"key"`
	Value interface{} `json:"value"`
}

type LarkUser struct {
	Email  string `json:"email"`
	Status uint64 `json:"status"`
}

type LeaderWordsReq struct {
	PerformanceID uint64 `json:"performance_id"`
	LeaderWords   string `json:"leader_words"`
}

type LeaderWordsResp struct {
}

type LineBarChartData struct {
	XAxis  []string            `json:"xAxis"`
	Series []LineBarSeriesItem `json:"series"`
}

type LineBarSeriesItem struct {
	Name       string    `json:"name"`
	Data       []float64 `json:"data"`
	Type       string    `json:"type"`
	YAxisIndex int       `json:"yAxisIndex,optional"`
}

type ListDepartmentReportsReq struct {
	DepartmentKey string `form:"department_key,optional"`
	ReportType    int32  `form:"report_type"`
	ReportDate    string `form:"report_date"`
	ReportStatus  int32  `form:"report_status,default=0,optional"`
	IsDelayed     int32  `form:"is_delayed,default=-1,optional"`
	HasRisk       int32  `form:"has_risk,default=-1,optional"`
}

type ListDepartmentReportsResp struct {
	List []Report `json:"list"`
}

type ListReportDelayAndRiskReq struct {
	ReportStartDate string `form:"report_start_date"`
	ReportEndDate   string `form:"report_end_date"`
	DepartmentKey   string `form:"department_key"`
}

type ListReportDelayAndRiskResp struct {
	DelayRiskList         interface{} `json:"list"`
	ShowInformBtnUserList []string    `json:"show_inform_btn_user_list"`
}

type ListReportMentionReq struct {
	ReportStartDate string `form:"report_start_date"`
	ReportEndDate   string `form:"report_end_date"`
	TargetUserEmail string `form:"target_user_email"`
}

type ListReportMentionResp struct {
	List interface{} `json:"list"`
}

type ListReportReq struct {
	ReportStartDate string `form:"report_start_date"`
	ReportEndDate   string `form:"report_end_date"`
	TargetUserEmail string `form:"target_user_email"`
	PageNum         int64  `form:"page_num,optional,default=1"`
	PageSize        int64  `form:"page_size,optional,default=10"`
}

type ListReportResp struct {
	Total uint64      `json:"total"`
	List  interface{} `json:"list"`
}

type Message struct {
	ID          uint64      `json:"id"`
	UserEmail   string      `json:"user_email"`
	MessageType int         `json:"message_type"`
	Status      int         `json:"status"`
	CreatedAt   string      `json:"created_at"`
	UpdatedAt   string      `json:"updated_at"`
	ExtraData   interface{} `json:"extra_data"`
}

type MessageAlignHandleReq struct {
	MessageId int64 `json:"message_id"`
	Status    int64 `json:"status"`
}

type MessageAssignHandleReq struct {
	MessageId          int64 `json:"message_id"`
	Status             int64 `json:"status"`
	KrUnderObjectiveId int64 `json:"kr_under_objective_id,optional"`
}

type MessageListReq struct {
	BasePaginationReq
	StartDate string `json:"start_date"`
	EndDate   string `json:"end_date"`
}

type MessageListResp struct {
	List  []Message `json:"list"`
	Total int       `json:"total"`
}

type MetricInfo struct {
	Tips        string `json:"tips"`
	CalcFormula string `json:"calc_formula"`
	Name        string `json:"name"`
}

type MetricItemData struct {
	Current    interface{} `json:"current"` // 当前值
	Last       interface{} `json:"last"`    // 上期值
	Score      float32     `json:"score"`   // 当前周期得分
	Trend      Trend       `json:"trend"`
	MetricInfo MetricInfo  `json:"metric_info"`
}

type ModifyCalcFormulaReq struct {
	ID            []int        `json:"id"`
	CalcFormula   []StringItem `json:"calc_formula"`
	EffectiveTime string       `json:"effective_time"`
}

type MonitorChartDataReq struct {
	MonitorMetricsListReq
	ChartTypeEnum
}

type MonitorChartDataResp struct {
	RadarData   interface{} `json:"radarData,optional"`
	LineData    interface{} `json:"lineData,optional"`
	BarData     interface{} `json:"barData,optional"`
	HeatmapData interface{} `json:"heatmapData,optional"`
}

type MonitorMetricsListReq struct {
	BasePaginationReq
	PeriodTypeEnum
	DepartmentKey string `json:"department_key"`
	DateFromTo    string `json:"date_from_to"`
	Employee      string `json:"employee,optional"`
}

type MonitorMetricsListResp struct {
	List  interface{} `json:"list"`
	Total int         `json:"total"`
}

type OKREntityView struct {
	AlignWithParent              bool     `json:"align_with_parent"`
	AlignWithParentByAssign      bool     `json:"align_with_parent_by_assign"`
	ByAssign                     bool     `json:"by_assign"`
	EntityId                     int64    `json:"entity_id"`
	EntityType                   int64    `json:"entity_type"`
	ParentEntityId               int64    `json:"parent_entity_id"`
	Content                      string   `json:"content"`
	Priority                     int64    `json:"priority"`
	Deadline                     string   `json:"deadline"`
	TypeForKr                    int64    `json:"type_for_kr"`
	Owner                        string   `json:"owner"`
	Position                     int64    `json:"position"`
	Weight                       string   `json:"weight"`
	IntendedOwner                string   `json:"intended_owner"`
	IntendedAlign                int64    `json:"intended_align"`
	EditableFieldsBySignedInUser []string `json:"editable_by_signed_in_user"`
}

type OKRTreeElem struct {
	OKREntityView OKREntityView  `json:"entity"`
	AlignWith     []*OKRTreeElem `json:"align_with"`
	Children      []*OKRTreeElem `json:"children"`
}

type OkrAckReq struct {
	OkrId uint64 `json:"okr_id"`
}

type OkrApplyAckReq struct {
	OkrId uint64 `json:"okr_id"`
}

type OkrDetailReq struct {
	StartDate string `form:"start_date"`
	EndDate   string `form:"end_date"`
	UserEmail string `form:"user_email,optional"`
}

type OkrDetailResp struct {
	OkrId             int64          `json:"okr_id,omitempty"`
	UserEmail         string         `json:"user_email,omitempty"`
	StartDate         string         `json:"start_date,omitempty"`
	EndDate           string         `json:"end_date,omitempty"`
	Status            int64          `json:"status,omitempty"`
	Children          []*OKRTreeElem `json:"children,omitempty"`
	UnHandledMessages int64          `json:"un_handled_messages"`
}

type OkrPosUpdateReq struct {
	ParentEntityId int64   `json:"parent_entity_id"`
	EntityIds      []int64 `json:"entity_ids"`
}

type OkrSuggestModifyReq struct {
	OkrId uint64 `json:"okr_id"`
}

type PageResult struct {
	List  interface{} `json:"list"`
	Total int64       `json:"total"`
}

type Performance struct {
	ID                 uint64     `json:"id"`
	UserEmail          string     `json:"user_email"`
	Year               uint64     `json:"year"`
	MonthNum           uint64     `json:"month_num"`
	WorkItemWeight     float64    `json:"work_item_weight"`
	AdditionItemWeight float64    `json:"addition_item_weight"`
	TotalScore         float64    `json:"total_score"`
	Level              string     `json:"level"`
	LeaderWords        string     `json:"leader_words"`
	Status             int32      `json:"status"`
	Department         Department `json:"department"`
	CreatedAt          string     `json:"created_at"`
	UpdatedAt          string     `json:"updated_at"`
}

type PerformanceAdditionItem struct {
	ID            uint64                   `json:"id"`
	ItemName      string                   `json:"item_name"`
	ItemType      int32                    `json:"item_type"`
	ItemDesc      string                   `json:"item_desc"`
	ItemWeight    float64                  `json:"item_weight"`
	SelfScore     float64                  `json:"self_score"`
	LeaderScore   float64                  `json:"leader_score"`
	CoworkerEmail string                   `json:"coworker_email"`
	Comments      []PerformanceItemComment `json:"comments"`
}

type PerformanceAdditionScore struct {
	ID            uint64  `json:"id"`
	ItemID        uint64  `json:"item_id"`
	PerformanceId uint64  `json:"performance_id"`
	Year          uint64  `json:"year"`
	MonthNum      uint64  `json:"month_num"`
	UserEmail     string  `json:"user_email"`
	Score         float64 `json:"score"`
	ItemDesc      string  `json:"item_desc"`
	Status        uint64  `json:"status"`
	CoworkerEmail string  `json:"coworker_email"`
	CreatedAt     string  `json:"created_at"`
	UpdatedAt     string  `json:"updated_at"`
}

type PerformanceItemComment struct {
	CommentID   uint64 `json:"comment_id"`
	ItemID      uint64 `json:"item_id"`
	CommentType uint64 `json:"comment_type"`
	UserEmail   string `json:"user_email"`
	Comment     string `json:"comment"`
	CreatedAt   string `json:"created_at"`
	UpdatedAt   string `json:"updated_at"`
}

type PerformanceLeaderAckReq struct {
	PerformanceID uint64 `json:"performance_id"`
}

type PerformanceLeaderAckResp struct {
}

type PerformanceRanking struct {
	PerformanceID           uint64                `json:"performance_id"`
	Year                    uint64                `json:"year"`
	MonthNum                uint64                `json:"month_num"`
	UserEmail               string                `json:"user_email"`
	Email                   string                `json:"email"`
	TotalScore              float64               `json:"total_score"`
	Level                   string                `json:"level"`
	LevelFactor             float64               `json:"level_factor"`
	TimeFactor              float64               `json:"time_factor"`
	IncidentDeduction       float64               `json:"incident_deduction"`
	ExcellentMemberBonus    float64               `json:"excellent_member_bonus"`
	ExcellentManagerBonus   float64               `json:"excellent_manager_bonus"`
	TotalBonus              float64               `json:"total_bonus"`
	IsExcellentEmployee     uint64                `json:"is_excellent_employee"`
	ExcellentEmployeeReason string                `json:"excellent_employee_reason"`
	WorkItems               []PerformanceWorkItem `json:"work_items"`
	Status                  int32                 `json:"status"`
	CreatedAt               string                `json:"created_at"`
	UpdatedAt               string                `json:"updated_at"`
}

type PerformanceSelfAckReq struct {
	PerformanceID uint64 `json:"performance_id"`
}

type PerformanceSelfAckResp struct {
}

type PerformanceWorkItem struct {
	ID            uint64                   `json:"id"`
	ItemName      string                   `json:"item_name"`
	ItemWeight    float64                  `json:"item_weight"`
	ItemDesc      string                   `json:"item_desc"`
	ItemDeficency string                   `json:"item_deficency"`
	SelfScore     float64                  `json:"self_score"`
	LeaderScore   float64                  `json:"leader_score"`
	Comments      []PerformanceItemComment `json:"comments"`
}

type PeriodTypeEnum struct {
	PeriodType int `json:"period_type,options=0|1|2|3|4"`
}

type PersonalChartDataReq struct {
	PersonalMetricsReq
	ChartType int `json:"chart_type,optional"` // 1 雷达图，2折线图
}

type PersonalMetricsReq struct {
	PeriodType int    `json:"period_type"`       // 周期类型
	DateFromTo string `json:"date_from_to"`      // 日期范围
	Employee   string `json:"employee,optional"` // 可选的员工标识
}

type PersonalMetricsResp struct {
	Id                     int64          `json:"id"`
	FailureRecurrenceRate  MetricItemData `json:"failure_recurrence_rate"`   // 故障复发率（百分比）
	AverageProcessingTime  MetricItemData `json:"average_processing_time"`   // 平均处理时间（秒）
	AverageResolutionTime  MetricItemData `json:"average_resolution_time"`   // 平均解决时间（秒）
	EffectiveHandledEvents MetricItemData `json:"effective_handled_events"`  // 有效处理事件
	BizEventAssignmentRate MetricItemData `json:"biz_event_assignment_rate"` // 事件分配率（百分比）
	BizRuleHitRate         MetricItemData `json:"biz_rule_hit_rate"`         // 规则命中率（百分比）
	ScoreInfo              ScoreInfo      `json:"score_info"`
	Nickname               string         `json:"nickname"`
}

type RadarChartData struct {
	Indicator []string      `json:"indicator"`
	Series    []RadarSeries `json:"series"`
}

type RadarSeries struct {
	Data []RadarSeriesData `json:"data"`
}

type RadarSeriesData struct {
	Name  string    `json:"name"`
	Value []float64 `json:"value"`
}

type Report struct {
	UserEmail         string          `json:"user_email"`
	ReportId          uint64          `json:"report_id"`
	ReportType        int32           `json:"report_type"`
	ReportDate        string          `json:"report_date"`
	IsDelayed         bool            `json:"is_delayed"`
	DelayReason       string          `json:"delay_reason"`
	HasRisk           bool            `json:"has_risk"`
	RiskDesc          string          `json:"risk_desc"`
	ReportStatus      int32           `json:"report_status"`
	CreatedAt         string          `json:"created_at"`
	UpdatedAt         string          `json:"updated_at"`
	ReportItemList    []ReportItem    `json:"report_item_list"`
	ReportCommentList []ReportComment `json:"report_comment_list"`
	Department        Department      `json:"department"`
}

type ReportComment struct {
	ReportCommentID uint64 `json:"report_comment_id"`
	UserEmail       string `json:"user_email"`
	Content         string `json:"content"`
	CreatedAt       string `json:"created_at"`
	UpdatedAt       string `json:"updated_at"`
}

type ReportItem struct {
	ReportItemId uint64   `json:"report_item_id,optional"`
	Content      string   `json:"content"`
	MentionList  []string `json:"mention_list"`
}

type ReportStatisticsReq struct {
	ReportStartDate string `form:"report_start_date"`
	ReportEndDate   string `form:"report_end_date"`
}

type ReportStatisticsResp struct {
	Departments Departments `json:"departments"`
}

type RollbackPerformanceStatusReq struct {
	PerformanceID uint64 `json:"performance_id"`
}

type RollbackPerformanceStatusResp struct {
}

type ScoreInfo struct {
	Score       float32 `json:"score"`
	Rank        int64   `json:"rank"`
	Tips        string  `json:"tips"`
	CalcFormula string  `json:"calc_formula"`
	Name        string  `json:"name"`
}

type Statistics struct {
	Level   string  `json:"level"`
	Count   uint64  `json:"count"`
	Percent float64 `json:"percent"`
}

type StringItem struct {
	Key   string `json:"key"`
	Value string `json:"value"`
}

type Trend struct {
	Type int         `json:"type"` // 趋势类型，1 上升，2 下降，3 持平
	Rate interface{} `json:"rate"` // 趋势率，当前值与上期值的变化率
}

type UpdateKeyResultReq struct {
	OkrId       int64   `json:"okr_id"`
	ObjectiveId int64   `json:"objective_id"`
	KeyResultId int64   `json:"keyresult_id"`
	UserEmail   string  `json:"user_email,optional"`
	TypeForKR   int64   `json:"type_for_kr,optional"`
	Content     string  `json:"content,optional"`
	Weight      float64 `json:"weight,optional"`
	Priority    int64   `json:"priority,optional"`
	Deadline    string  `json:"deadline,optional"`
}

type UpdateKeyResultResp struct {
}

type UpdateMessageStatusReq struct {
	MessageId int64 `json:"message_id"`
	Status    int64 `json:"status"`
}

type UpdateMessageStatusResp struct {
}

type UpdateObjectiveReq struct {
	OkrId       uint64  `json:"okr_id"`
	ObjectiveId uint64  `json:"objective_id"`
	Content     string  `json:"content,optional"`
	Weight      float64 `json:"weight,optional"`
	Priority    int64   `json:"priority,optional"`
	Deadline    string  `json:"deadline,optional"`
}

type UpdateObjectiveResp struct {
}

type UpdateOkrTaskReq struct {
	OkrId       uint64  `json:"okr_id"`
	ObjectiveId uint64  `json:"objective_id"`
	KeyResultId uint64  `json:"keyresult_id"`
	TaskId      uint64  `json:"task_id"`
	UserEmail   string  `json:"user_email"`
	Content     string  `json:"content"`
	Weight      float32 `json:"weight"`
	Priority    int64   `json:"priority"`
	Deadline    string  `json:"deadline"`
}

type UpdatePerformanceAdditionItemReq struct {
	ItemID        uint64  `json:"item_id"`
	ItemDesc      string  `json:"item_desc,optional"`
	SelfScore     float64 `json:"self_score,optional"`
	CoworkerEmail string  `json:"coworker_email,optional"`
	LeaderScore   float64 `json:"leader_score,optional"`
}

type UpdatePerformanceAdditionItemResp struct {
}

type UpdatePerformanceAdditionScoreReq struct {
	ItemId    uint64  `json:"item_id"`
	Score     float64 `json:"score"`
	ItemDesc  string  `json:"item_desc"`
	UserEmail string  `json:"user_email,optional"`
}

type UpdatePerformanceAdditionScoreResp struct {
}

type UpdatePerformanceBonusReq struct {
	PerformanceID           uint64  `json:"performance_id"`
	TimeFactor              float64 `json:"time_factor,range=[0:2]"`
	LevelFactor             float64 `json:"level_factor"`
	IncidentDeduction       float64 `json:"incident_deduction"`
	ExcellentMemberBonus    float64 `json:"excellent_member_bonus"`
	ExcellentManagerBonus   float64 `json:"excellent_manager_bonus"`
	IsExcellentEmployee     uint64  `json:"is_excellent_employee,optional,options=1|2"`
	ExcellentEmployeeReason string  `json:"excellent_employee_reason,optional"`
}

type UpdatePerformanceBonusResp struct {
}

type UpdatePerformanceItemCommentReq struct {
	PerformanceID uint64 `json:"performance_id"`
	CommentID     uint64 `json:"comment_id"`
	Comment       string `json:"comment"`
}

type UpdatePerformanceItemCommentResp struct {
}

type UpdatePerformanceStatusUpdateReq struct {
	UserEmail     string   `json:"user_email,optional"`
	PerformanceID []uint64 `json:"performance_id"`
	Status        uint64   `json:"status,options=5|50|51"`
}

type UpdatePerformanceStatusUpdateResp struct {
}

type UpdatePerformanceWorkItemReq struct {
	ItemID        uint64  `json:"item_id"`
	ItemName      string  `json:"item_name,optional"`
	ItemWeight    float64 `json:"item_weight,optional"`
	ItemDesc      string  `json:"item_desc,optional"`
	ItemDeficency string  `json:"item_deficency,optional"`
	SelfScore     float64 `json:"self_score,optional"`
	LeaderScore   float64 `json:"leader_score,optional"`
}

type UpdatePerformanceWorkItemResp struct {
}

type UpdateReportReq struct {
	ReportID       uint64       `json:"report_id"`
	ReportItemList []ReportItem `json:"report_item_list"`
	IsDelayed      bool         `json:"is_delayed"`
	DelayReason    string       `json:"delay_reason,optional"`
	HasRisk        bool         `json:"has_risk"`
	RiskDesc       string       `json:"risk_desc,optional"`
	IsDraft        bool         `json:"is_draft"` // 是否为草稿
}

type UpdateReportResp struct {
}

type UserInfo struct {
	Nickname        string `json:"nickname"`
	Email           string `json:"email"`
	LarkHeaderImage string `json:"larkHeaderImage"`
	IsLeader        bool   `json:"is_leader"`          // 该用户是否为部门领导
	UserStatus      int32  `json:"user_status"`        // 用户状态：1: 在职；2: 离职
	OkrStatus       int32  `json:"okr_status"`         // OKR状态; 1未确认，2待确认，3已确认
	Status          int32  `json:"performance_status"` // 绩效状态;
	JoinTime        int64  `json:"join_time"`          // 入职时间
	JoinDate        string `json:"join_date"`          // 入职日期
}

type UserListReq struct {
	DepartmentKeys []string `json:"department_keys,optional"`
}
