package config

import (
	"github.com/zeromicro/go-zero/core/stores/redis"
	"github.com/zeromicro/go-zero/zrpc"
)

type Config struct {
	zrpc.RpcServerConf
	DB struct {
		DataSource string
	}
	Env       string
	RedisConf redis.RedisConf

	LbkUsercenter  LbkUsercenter
	Lark           Lark
	UserCenter     UserCenter
	EfficiencyCalc EfficiencyCalc
}

type LbkUsercenter struct {
	AppName   string
	AppToken  string
	Env       string
	HostInAli bool
}

type Lark struct {
	AppId                 string
	AppSecret             string
	PerformanceTmpId      string // 绩效消息通知模板
	ReportRemindTmpId     string // 日报提醒消息模板
	GenericPlainTextTmpId string // 通用纯文本消息模板
	MyPerformanceUrl      string // 我的绩效查看地址
	StaffPerformanceUrl   string // 下属绩效查看地址
	ScorePerformanceUrl   string // 评分绩效查看地址
	PerformanceResUrl     string // 绩效结果查看地址
}

type UserCenter struct {
	URL                string
	DepartmentUserPath string
}

type EfficiencyCalc struct {
	Admin []string
}
