package cron

import (
	"context"
	"github.com/zeromicro/go-zero/core/logx"
	performancelogic "oa-server/app/oacenter/oa_rpc/internal/logic/performancerpc"
	reportrpclogic "oa-server/app/oacenter/oa_rpc/internal/logic/reportrpc"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/common/timer"
	"oa-server/common/tool"
	"time"
)

func Init(ctx *svc.ServiceContext) {
	timer_ := timer.NewTimerTask()
	_, err := timer_.AddTaskByFunc("提醒写日报", "0 0 20 * * *", func() {
		tool.GoSafe(func() {
			if !tool.IsWorkingDay(time.Now(), time.Local) {
				return
			}
			l := reportrpclogic.NewGetReportStatisticsLogic(context.Background(), ctx)
			l.CheckAndRemindTodayReport()
		})
	})
	logx.Must(err)

	year := time.Now().Year()
	month := time.Now().Format("01") //AddDate(0, 1, 0).
	mapYearMonth := map[string]uint64{
		"02": 1,
		"04": 2,
		"06": 3,
		"08": 4,
		"10": 5,
		"12": 6,
	}
	_, err = timer_.AddTaskByFunc("自动创建绩效", "0 0 23 25 2,4,6,8,10,12 *", func() { //0 0 23 25 2,4,6,8,10,12 *   0 */1 * * * *
		tool.GoSafe(func() {
			l := performancelogic.NewCreatePerformanceLogic(context.Background(), ctx)
			err := l.BatchCreatePerformance(uint64(year), mapYearMonth[month])
			if err != nil {
				logx.Error(err)
				return
			}
			return
		})
	})

	logx.Must(err)
}
