package calcrpclogic

import (
	"context"

	"oa-server/app/oacenter/model/efficiency_calc"
	"oa-server/app/oacenter/oa_rpc/internal/logic/tools"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type CalcHistoryListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewCalcHistoryListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CalcHistoryListLogic {
	return &CalcHistoryListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *CalcHistoryListLogic) CalcHistoryList(in *oa.CalcHistoryListReq) (*oa.CalcHistoryListResp, error) {
	total, list, err := l.svcCtx.EfficiencyCalcHistoryModel.ListHistory(l.ctx, &efficiency_calc.ListHistoryReq{
		CalcID:   uint64(in.Id),
		Page:     int(in.PageNum),
		PageSize: int(in.PageSize),
	})
	if err != nil {
		return nil, err
	}
	departmentMap, err := l.svcCtx.UserCache.GetDepartmentMap(l.ctx)
	if err != nil {
		logx.Errorw("GetDepartmentMap failed", logx.Field("error", err))
		return nil, err
	}
	respList := make([]*oa.CalcHistoryList, 0)
	for _, v := range list {
		respList = append(respList, &oa.CalcHistoryList{
			Id:             int64(v.Id),
			UpdateUser:     v.Operator.String,
			EffectiveTime:  v.EffectiveTime.Time.Format("2006-01-02"),
			RoleName:       tools.RoleMap[v.Role.Int64],
			IndexName:      tools.CalcIndexMap[v.CalcIndex.Int64],
			Index:          oa.CalcIndex(v.CalcIndex.Int64),
			CalcFormula:    v.CalcFormula,
			UpdateTime:     v.CreatedAt.Format("2006-01-02 15:04:05"),
			DepartmentName: departmentMap[v.DepartmentKey.String].DepartmentName,
		})

	}

	return &oa.CalcHistoryListResp{
		Total: int64(total),
		List:  respList,
	}, nil
}
