package common

import (
	"iter"
	"log"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

const (
	OA_RUNTIME_PROD_ENV = "pro" // OA运行环境 生产环境
)

var (
	ErrPermissionDenied = status.Error(codes.PermissionDenied, "无权限操作")

	ErrUsercenterUnavailable = status.Error(codes.Unavailable, "请求用户中心失败, 请求稍后再试")
)

func GetDepartmentKeyList(departments []usercenter.Department) []string {
	keys := make([]string, len(departments))
	for i, d := range departments {
		keys[i] = d.DepartmentKey
	}
	return keys
}

func IsContainDepartment(departmentList []usercenter.Department, departmentKey string) bool {
	for _, d := range departmentList {
		if d.DepartmentKey == departmentKey {
			return true
		}
	}

	return false
}

func GetUserByEmail(users []*usercenter.PublicLbkUserOutside, email string) *usercenter.PublicLbkUserOutside {
	for _, u := range users {
		if u.Email == email {
			return u
		}
	}
	return nil
}

func safeGo(fn func()) {
	go func() {
		defer func() {
			if err := recover(); err != nil {
				log.Println("recover from panic ", err)
			}
		}()
		fn()
	}()
}

func AsyncSendLarkMsg(env string, fn func()) {
	if env != OA_RUNTIME_PROD_ENV {
		// 非生产环境不发消息
		return
	}
	safeGo(fn)
}

// Filter returns a sequence that contains the elements
// of s for which f returns true.
func Filter[V any](f func(V) bool, s iter.Seq[V]) iter.Seq[V] {
	return func(yield func(V) bool) {
		for v := range s {
			if f(v) {
				if !yield(v) {
					return
				}
			}
		}
	}
}

func Map[V any, V2 any](mapFunc func(V) V2, s iter.Seq[V]) iter.Seq[V2] {
	return func(yield func(V2) bool) {
		for v := range s {
			if !yield(mapFunc(v)) {
				return
			}
		}
	}
}
