package monitorrpclogic

import (
	"context"
	"fmt"

	"oa-server/app/oacenter/model/monitor_metrics"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetMonitorMetricsListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetMonitorMetricsListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetMonitorMetricsListLogic {
	return &GetMonitorMetricsListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *GetMonitorMetricsListLogic) GetMonitorMetricsList(in *oa.MetricsListReq) (*oa.MetricsListResp, error) {

	modelReq := &monitor_metrics.ListReq{
		PeriodType:    int64(in.PeriodType),
		DepartmentKey: in.DepartmentKey,
		Page:          int64(in.Page),
		PageSize:      int64(in.PageSize),
		DateFromTo:    []string{in.DateFromTo},
	}

	if in.Employee != nil {
		modelReq.Employee = *in.Employee
	}

	total, metrics, err := l.svcCtx.MonitorMetricsModel.List(l.ctx, modelReq)
	if err != nil {
		logx.Errorf("List metrics error: %v", err)
		return nil, fmt.Errorf("获取监控指标列表失败: %v", err)
	}

	list := make([]*oa.MetricsInfo, 0, len(metrics))
	for _, v := range metrics {
		metricsInfo := &oa.MetricsInfo{
			Id: v.Id,
		}

		if v.NickName.Valid {
			metricsInfo.Nickname = v.NickName.String
		}

		if v.Employee.Valid {
			metricsInfo.Email = v.Employee.String
		}
		if v.DepartmentName.Valid {
			metricsInfo.DepartmentName = v.DepartmentName.String
		}

		var dto *monitor_metrics.MonitorMetricsDTO

		dto, err := v.ToDTO()
		if err != nil {
			logx.Errorf("ToDTO error: %v", err)
			return nil, fmt.Errorf("获取监控指标列表失败: %v", err)
		}

		l.setMetricValues(metricsInfo, dto)

		list = append(list, metricsInfo)
	}

	return &oa.MetricsListResp{
		List:  list,
		Total: total,
	}, nil
}

func (l *GetMonitorMetricsListLogic) setMetricValues(info *oa.MetricsInfo, dto *monitor_metrics.MonitorMetricsDTO) {
	info.EffectiveHandledEvents = int64(dto.EffectiveHandledEvents.Current)

	info.AverageProcessingTime = int64(dto.AverageProcessingTime.Current)

	info.AverageResolutionTime = int64(dto.AverageResolutionTime.Current)

	info.FailureRecurrenceRate = dto.FailureRecurrenceRate.Current

	info.BizEventAssignmentRate = dto.BizEventAssignmentRate.Current

	info.BizRuleHitRate = dto.BizRuleHitRate.Current

	info.MonitorScore = dto.Score.Float64
}
