package okrrpclogic

import (
	"context"
	"encoding/json"
	"errors"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"oa-server/app/oacenter/model/okr"
	"time"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type AssignAddLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewAssignAddLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AssignAddLogic {
	return &AssignAddLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *AssignAddLogic) AssignAdd(in *oa.AssignAddReq) (*oa.EmptyResponse, error) {
	if in.IntendedOwner == in.UserEmail {
		return nil, errors.New("invalid req")
	}
	err := l.svcCtx.OkrTaskModel.TransCtx(l.ctx, func(ctx context.Context, session sqlx.Session) error {
		entity, err := okr.NewXOKrTaskModel(sqlx.NewSqlConnFromSession(session)).FindOne(ctx, in.EntityId)
		if err != nil {
			return err
		}
		if entity.Owner != in.UserEmail {
			return errors.New("invalid req")
		}
		entity.IntendedOwner = in.IntendedOwner
		err = okr.NewXOKrTaskModel(sqlx.NewSqlConnFromSession(session)).Update(ctx, entity)
		if err != nil {
			return err
		}
		////todo check period 可编辑
		period, err := okr.NewXOkrPeriodModel(sqlx.NewSqlConnFromSession(session)).FindOne(ctx, entity.PeriodId)
		if err != nil {
			return err
		}
		entityAndTheirAncestors, err := l.svcCtx.OkrTaskModel.GetEntityRootPaths(ctx, session, []int64{in.EntityId})
		if err != nil {
			return err
		}

		content := okr.MsgContentAssignReq{
			MsgContentAssign: okr.MsgContentAssign{
				EntityId:        in.EntityId,
				ReqBy:           in.UserEmail,
				ReqHandleBy:     in.IntendedOwner,
				ReqHandleResult: 0,
				EntityPath:      entityAndTheirAncestors,
			},
		}
		jsonContent, _ := json.Marshal(content)
		msg := &okr.XOkrMsg{
			Id:             0,
			FromUser:       in.UserEmail,
			ToUser:         in.IntendedOwner,
			Type:           3,
			Content:        string(jsonContent),
			ApprovalStatus: 1,
			StartDate:      period.StartDate,
			EndDate:        period.EndDate,
			CreatedAt:      time.Time{},
			UpdatedAt:      time.Time{},
		}
		_, err = okr.NewXOkrMsgModel(sqlx.NewSqlConnFromSession(session)).Insert(ctx, msg)
		if err != nil {
			return err
		}
		return nil
	})
	if err != nil {
		return nil, err
	}

	return &oa.EmptyResponse{}, nil
}
