package okrrpclogic

import (
	"fmt"
	"strings"
	"time"

	"oa-server/app/oacenter/model/okr"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/shopspring/decimal"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

const (
	// entity_type
	OkrEntityTypeObjective = 1 // objective类型
	OkrEntityTypeKeyresult = 2 // keyresult类型
	OkrEntityTypeTask      = 3 // 任务类型

	// keyresult类型
	KeyresultTypeGuarantee = 1 // 承诺类型
	KeyresultTypeChallenge = 2 // 挑战类型

	// okr message status
	OkrMessageApprovalStatusUnhandled = 1 // 未处理
	OkrMessageApprovalStatusHandled   = 2 // 已处理

	// okr message type
	OkrMessgeTypeAlignReq   = 1 // 对齐REQ
	OkrMessgeTypeAlignResp  = 2 // 对齐RESP
	OkrMessgeTypeAssignReq  = 3 // 分配REQ
	OkrMessgeTypeAssignResp = 4 //分配RESP
	OkrMessgeTypeAckReq     = 5 // 确认REQ
	OkrMessgeTypeAckResp    = 6 // 确认RESP
)

var (
	ErrInvalidParams    = status.Error(codes.InvalidArgument, "无效的参数")
	ErrPermissionDenied = status.Error(codes.PermissionDenied, "无权限操作")

	// OKR
	ErrOkrPeriodInvalid     = status.Error(codes.InvalidArgument, "不在OKR创建周期内")
	ErrOkrNotFound          = status.Error(codes.NotFound, "Okr不存在")
	ErrOkrAddFailed         = status.Error(codes.Internal, "添加Okr失败")
	ErrOkrExists            = status.Error(codes.Internal, "Okr已存在")
	ErrOkrPeriodQueryFailed = status.Error(codes.Internal, "查询OKR失败")

	// OKR Task
	ErrOkrTaskNotFound     = status.Error(codes.NotFound, "OkrTask不存在")
	ErrOkrTaskAddFailed    = status.Error(codes.Internal, "添加OkrTask失败")
	ErrOkrTaskUpdateFailed = status.Error(codes.Internal, "更新OkrTask失败")
	ErrOkrTaskDeleteFailed = status.Error(codes.Internal, "删除OkrTask失败")
	ErrOkrTaskQueryFailed  = status.Error(codes.Internal, "查询OkrTask失败")
	ErrOkrTaskExists       = status.Error(codes.Internal, "OkrTask已存在")

	// OKR Msg
	ErrOkrMsgOperateFailed = status.Error(codes.Internal, "操作OkrMsg失败")
	ErrOkrMsgNotFound      = status.Error(codes.NotFound, "OkrMsg不存在")
	ErrOkrMsgAddFailed     = status.Error(codes.Internal, "添加OkrMsg失败")
	ErrOkrMsgUpdateFailed  = status.Error(codes.Internal, "更新OkrMsg失败")
	// OKR ALIGNMENT
	ErrOkrAlignmentQueryFailed = status.Error(codes.Internal, "查询OkrAlignment失败")
)

var (
	HundredPercent = decimal.NewFromFloat(100)
)

// okr是否可修改
func IsOkrEditable(m *okr.XOkrPeriod, userEmail string) bool {
	if m == nil {
		return false
	}

	// 不是自己的Okr不允许修改
	if m.Owner != userEmail {
		return false
	}

	// 已经确认过的OKR不允许修改
	if m.ApprovalStatus == int64(oa.OkrStatus_OKR_STATUS_ACKED) {
		return false
	}

	// todo 非创建期不允许修改
	if !isCreateOkr(m.StartDate.Format(time.DateOnly)) {
		return false
	}
	return true
}

// 生成绩效lark消息通知的标题
func genPerformanceLarkMsgTitle(year, monthNum uint64) string {
	monthStr := fmt.Sprintf("%d~%d月", 2*monthNum-1, 2*monthNum)
	if monthNum <= 0 || monthNum > 6 {
		monthStr = ""
	}
	return fmt.Sprintf("%d年%s绩效考核", year, monthStr)
}

func extractEmailUsername(email string) string {
	if email == "" {
		return email
	}

	ret := strings.Split(email, "@")
	return ret[0]
}

// 判断是否是创建OKR的时间
func isCreateOkr(date string) bool {
	return true
	//timeDate, err := time.ParseInLocation(time.DateOnly, date, time.Local)
	//if err != nil {
	//	return false
	//}
	//// 前15天后14天都属于创建OKR的时间
	//startDate := timeDate.AddDate(0, 0, -15)
	//endDate := timeDate.AddDate(0, 0, 15)
	//// 当前时间是否在startDate和endDate之间
	//now := time.Now()
	////now := time.Date(2025, time.April, 15, 0, 0, 0, 1, time.Local) //给定一个指定时间
	//fmt.Println(startDate, endDate, now, now.After(startDate), now.After(startDate))
	//if now.After(startDate) && now.Before(endDate) {
	//	return true
	//} else {
	//	return false
	//}

}
