package okrrpclogic

import (
	"context"
	"oa-server/app/oacenter/model/okr"
	"time"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateObjectiveLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewCreateObjectiveLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateObjectiveLogic {
	return &CreateObjectiveLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *CreateObjectiveLogic) CreateObjective(in *oa.CreateObjectiveReq) (*oa.CreateObjectiveResp, error) {
	// todo: add your logic here and delete this line
	okrPeriod, err := l.svcCtx.OkrPeriodModel.FindOne(l.ctx, in.OkrId)
	if err != nil {
		l.Logger.Errorw("failed to find okr period", logx.Field("error", err))
		return nil, ErrOkrNotFound
	}
	if !isCreateOkr(okrPeriod.StartDate.Format(time.DateOnly)) {
		return nil, ErrOkrPeriodInvalid
	}
	if okrPeriod.Owner != in.UserEmail {
		return nil, ErrPermissionDenied
	}
	deadline, err := time.ParseInLocation(time.DateOnly, in.Deadline, time.Local)
	if err != nil {
		logx.Errorw("截止时间格式错误", logx.Field("err", err), logx.Field("deadline", in.Deadline))
		return nil, err
	}
	list, _ := l.svcCtx.OkrTaskModel.GetByOkrPeriodIdAndEntityType(in.OkrId, 1) // 1 代表objective 获取周期下的objective,一开始没有objective，所以获取不到
	req := okr.XOKrTask{
		Owner:          in.UserEmail,
		Content:        in.Content,
		EntityType:     1,        //'类型枚举: o1，kr2，task3',
		PeriodId:       in.OkrId, // 来自哪个okr周期
		ParentEntityId: 0,        //'父级id',
		Priority:       in.Priority,
		Deadline:       deadline,
		TypeForKr:      1, //'kr类型枚举: 1承诺型、2挑战型，默认为承诺型'
		Weight:         in.Weight,
		Position:       int64(len(list) + 1),
	}
	res, err := l.svcCtx.OkrTaskModel.Insert(l.ctx, &req)
	if err != nil {
		l.Logger.Errorw("failed to insert x_okr_task", logx.Field("error", err))
		return nil, ErrOkrTaskAddFailed
	}
	id, err := res.LastInsertId()
	if err != nil {
		logx.Errorw("failed to get okr_task id after db insert on OkrTask", logx.Field("error", err))
		return nil, ErrOkrTaskAddFailed
	}
	return &oa.CreateObjectiveResp{ObjectiveId: id}, nil
}
