package okrrpclogic

import (
	"context"
	"fmt"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
	"time"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeleteObjectiveLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDeleteObjectiveLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeleteObjectiveLogic {
	return &DeleteObjectiveLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *DeleteObjectiveLogic) DeleteObjective(in *oa.DeleteObjectiveReq) (*oa.DeleteObjectiveResp, error) {
	// todo: add your logic here and delete this line
	okrPeriod, err := l.svcCtx.OkrPeriodModel.FindOne(l.ctx, in.OkrId)
	if err != nil {
		l.Logger.Errorw("failed to find okr period", logx.Field("error", err))
		return nil, ErrOkrNotFound
	}
	if !isCreateOkr(okrPeriod.StartDate.Format(time.DateOnly)) {
		return nil, ErrOkrPeriodInvalid
	}
	if okrPeriod.Owner != in.UserEmail {
		return nil, ErrPermissionDenied
	}
	taskModel, err := l.svcCtx.OkrTaskModel.FindOne(l.ctx, in.ObjectiveId)
	if err != nil {
		l.Logger.Errorw("failed to find objective", logx.Field("error", err))
		return nil, ErrOkrTaskNotFound
	}
	if taskModel.Owner != in.UserEmail {
		return nil, ErrPermissionDenied
	}
	entityIds := []int64{in.ObjectiveId}
	//获取O下面的KR
	krList, err := l.svcCtx.OkrTaskModel.GetByParentEntityId(in.ObjectiveId)
	if err != nil {
		l.Logger.Errorw("failed to get kr list", logx.Field("error", err))
		return nil, ErrOkrTaskNotFound
	}
	//获取KR下面的task
	for _, kr := range krList {
		entityIds = append(entityIds, kr.EntityId)
		taskList, err := l.svcCtx.OkrTaskModel.GetByParentEntityId(kr.EntityId)
		if err != nil {
			l.Logger.Errorw("failed to get task list", logx.Field("error", err))
			return nil, ErrOkrTaskNotFound
		}
		for _, task := range taskList {
			entityIds = append(entityIds, task.EntityId)
		}
	}
	fmt.Println("task表所有相关的entityId:", entityIds)
	//放在事务中，还要操作其他表todo
	err = l.svcCtx.OkrTaskModel.TransCtx(l.ctx, func(ctx context.Context, session sqlx.Session) error {
		err = l.svcCtx.OkrTaskModel.TransDeleteCtx(l.ctx, session, entityIds) //删除周期下的所有任务(谨慎操作)，如果是别人对齐的这个周期，因为okrId不一样，所以不会删除，别人依然可以看到kr，task，但是看不到对齐的O了
		if err != nil {
			l.Logger.Errorw("failed to delete x_okr_task", logx.Field("error", err))
			return err
		}
		//align_with_entity（也就是objectiveId），获取都有谁对齐了这个O，然后分别删除对齐关系
		if err = l.svcCtx.OkrAlignmentModel.DeleteByAlignWithEntityIdAndUserEmail(l.ctx, session, taskModel.EntityId, in.UserEmail); err != nil {
			l.Logger.Errorw("failed to delete x_okr_alignment by align_with_entity and align_with_user", logx.Field("error", err))
			return err
		}
		//根据entityId（也就是objectiveId），获取这个Od都是对齐了哪些，然后分别删除对齐关系
		if err = l.svcCtx.OkrAlignmentModel.DeleteByEntityId(l.ctx, session, taskModel.EntityId); err != nil {
			l.Logger.Errorw("failed to delete x_okr_alignment by entityId", logx.Field("error", err))
			return err
		}
		return nil
	})
	if err != nil {
		l.Logger.Errorw("failed to delete x_okr_task objective and others", logx.Field("error", err))
		return nil, ErrOkrTaskDeleteFailed
	}
	return &oa.DeleteObjectiveResp{}, nil
}
