package okrrpclogic

import (
	"context"
	"time"

	"oa-server/app/oacenter/model/okr"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type MessageListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewMessageListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *MessageListLogic {
	return &MessageListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *MessageListLogic) MessageList(in *oa.MessageListReq) (*oa.OkrMessageListResp, error) {
	startTime, err := time.ParseInLocation(time.DateOnly, in.StartDate, time.Local)
	if err != nil {
		return nil, err
	}

	endTime, err := time.ParseInLocation(time.DateOnly, in.EndDate, time.Local)
	if err != nil {
		return nil, err
	}
	total, msgs, err := l.svcCtx.OkrMsgModel.List(&okr.MsgListReq{
		StartDate: startTime,
		EndDate:   endTime,
		ToUser:    in.UserEmail,
		Page:      int(in.PageNum),
		PageSize:  int(in.PageSize),
	})

	list := make([]*oa.OkrMessage, 0)
	for _, msg := range msgs {
		list = append(list, &oa.OkrMessage{
			Id:          msg.Id,
			UserEmail:   msg.FromUser,
			MessageType: msg.Type,
			Status:      msg.ApprovalStatus,
			CreatedAt:   msg.CreatedAt.Format(time.DateTime),
			UpdatedAt:   msg.UpdatedAt.Format(time.DateTime),
			ExtraData:   msg.Content,
		})
	}

	return &oa.OkrMessageListResp{
		Total:             int64(total),
		List:              list,
	}, nil
}
