package okrrpclogic

import (
	"context"
	"errors"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrAckLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewOkrAckLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrAckLogic {
	return &OkrAckLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *OkrAckLogic) OkrAck(in *oa.OkrAckReq) (*oa.EmptyResponse, error) {
	err := checkWeight(l.ctx, l.svcCtx.OkrTaskModel, l.svcCtx.OkrAlignmentModel, int64(in.OkrId))
	if err != nil {
		return nil, err
	}
	okrPeriod, err := l.svcCtx.OkrPeriodModel.FindOne(l.ctx, int64(in.OkrId))
	if err != nil {
		logx.Errorw("获取okr状态失败", logx.Field("err", err), logx.Field("okr_id", in.OkrId))
		return nil, err
	}
	user, err := l.svcCtx.UserCache.GetUserByEmail(l.ctx, okrPeriod.Owner)
	if err != nil {
		logx.Errorw("获取用户信息失败", logx.Field("err", err), logx.Field("email", in.AckBy))
		return nil, err
	}
	if user.LeaderEmail != in.AckBy {
		return nil, errors.New("您非该员工直属领导")
	}
	okrPeriod.ApprovalStatus = int64(oa.OkrStatus_OKR_STATUS_ACKED)

	err = l.svcCtx.OkrPeriodModel.Update(l.ctx, okrPeriod)
	if err != nil {
		logx.Errorw("更新okr状态失败", logx.Field("err", err), logx.Field("okr_id", in.OkrId))
		return nil, err
	}

	return &oa.EmptyResponse{}, nil
}
