package okrrpclogic

import (
	"context"
	"oa-server/app/oacenter/model/okr"
	"time"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrAddLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewOkrAddLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrAddLogic {
	return &OkrAddLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *OkrAddLogic) OkrAdd(in *oa.OkrAddReq) (*oa.OkrAddResp, error) {
	// todo: add your logic here and delete this line
	startDate, err := time.ParseInLocation(time.DateOnly, in.StartDate, time.Local)
	if err != nil {
		l.Logger.Errorw("failed to parse start date", logx.Field("error", err))
		return nil, ErrOkrAddFailed
	}
	if !isCreateOkr(in.StartDate) {
		return nil, ErrOkrPeriodInvalid
	}
	endDate, err := time.ParseInLocation(time.DateOnly, in.EndDate, time.Local)
	if err != nil {
		l.Logger.Errorw("failed to parse end date", logx.Field("error", err))
		return nil, ErrOkrAddFailed
	}
	// 检查是否存在相同的时间段，如何将字符串日期转为time.time时间格式
	info, err := l.svcCtx.OkrPeriodModel.FindOneByOwnerStartDateEndDate(l.ctx, in.Owner, startDate, endDate)
	if info != nil {
		l.Logger.Errorw("x_okr_period exists", logx.Field("error", err))
		return nil, ErrOkrExists
	}
	req := okr.XOkrPeriod{
		Owner:                in.Owner,
		StartDate:            startDate,
		EndDate:              endDate,
		OwnerDepartmentKeys:  in.OwnerDepartmentKeys,
		OwnerDepartmentNames: in.OwnerDepartmentNames,
		ApprovalStatus:       int64(oa.OkrStatus_OKR_STATUS_NEED_ACKED), // '确认状态枚举: 1未确认，2待确认，3已确认',
	}
	res, err := l.svcCtx.OkrPeriodModel.Insert(l.ctx, &req)
	if err != nil {
		l.Logger.Errorw("failed to insert x_okr_period", logx.Field("error", err))
		return nil, ErrOkrExists
	}
	id, err := res.LastInsertId()
	if err != nil {
		logx.Errorw("failed to get okr_period id after db insert on OkrPeriod", logx.Field("error", err))
		return nil, ErrOkrAddFailed
	}
	return &oa.OkrAddResp{OkrId: uint64(id)}, nil
}
