package okrrpclogic

import (
	"context"
	"encoding/json"
	"errors"
	"oa-server/app/oacenter/model/okr"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrSuggestModifyLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewOkrSuggestModifyLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrSuggestModifyLogic {
	return &OkrSuggestModifyLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *OkrSuggestModifyLogic) OkrSuggestModify(in *oa.OkrSuggestModifyReq) (*oa.EmptyResponse, error) {
	okrPeriod, err := checkOkrStatus(l.svcCtx.OkrPeriodModel, int64(in.OkrId))
	if err != nil {
		return nil, err
	}
	user, err := l.svcCtx.UserCache.GetUserByEmail(l.ctx, okrPeriod.Owner)
	if err != nil {
		logx.Errorw("获取用户信息失败", logx.Field("err", err), logx.Field("email", in.SuggestModifyBy))
		return nil, err
	}
	if user.LeaderEmail != in.SuggestModifyBy {
		return nil, errors.New("您非该员工直属领导")
	}
	// 将okr修改为未确认状态
	okrPeriod.ApprovalStatus = 1
	err = l.svcCtx.OkrPeriodModel.Update(l.ctx, okrPeriod)
	if err != nil {
		logx.Errorw("更新okr状态失败", logx.Field("err", err), logx.Field("okrId", in.OkrId))
		return nil, err
	}

	msgContent := &okr.MsgConfirmResp{
		EntityId:    int64(in.OkrId),
		ReqBy:       in.SuggestModifyBy,
		ReqHandleBy: okrPeriod.Owner,
	}
	msgContentJson, err := json.Marshal(msgContent)
	if err != nil {
		logx.Errorw("序列化msgContent失败", logx.Field("err", err), logx.Field("msgContent", msgContent))
		return nil, err
	}
	msg := &okr.XOkrMsg{
		FromUser:       in.SuggestModifyBy,
		ToUser:         okrPeriod.Owner,
		Type:           6, // 1:对齐Req 2:对齐Resp 3:分配Req 4:分配Resp 5:确认Req 6:确认Resp
		Content:        string(msgContentJson),
		ApprovalStatus: 1,
		StartDate:      okrPeriod.StartDate,
		EndDate:        okrPeriod.EndDate,
	}
	_, err = l.svcCtx.OkrMsgModel.Insert(l.ctx, msg)
	if err != nil {
		logx.Errorw("插入消息失败", logx.Field("err", err), logx.Field("msg", msg))
		return nil, err
	}
	return &oa.EmptyResponse{}, nil
}
