package okrrpclogic

import (
	"context"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type OkrTaskDeleteLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewOkrTaskDeleteLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OkrTaskDeleteLogic {
	return &OkrTaskDeleteLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *OkrTaskDeleteLogic) OkrTaskDelete(in *oa.OkrTaskDeleteReq) (*oa.EmptyResponse, error) {
	// 获取okr状态
	okrPeriod, err := checkOkrStatus(l.svcCtx.OkrPeriodModel, int64(in.OkrId))
	if err != nil {
		return nil, err
	}
	if okrPeriod.Owner != in.UserEmail {
		return nil, ErrPermissionDenied
	}
	okrTask, err := l.svcCtx.OkrTaskModel.FindOne(l.ctx, int64(in.TaskId))
	if err != nil {
		logx.Errorw("获取task详情失败", logx.Field("id", in.TaskId))
		return nil, err
	}
	// 指派给自己或者未被接受时，直接删除
	if okrTask.Owner == in.UserEmail {
		err = l.svcCtx.OkrTaskModel.Delete(l.ctx, int64(in.TaskId))
		if err != nil {
			logx.Errorw("删除task失败", logx.Field("err", err), logx.Field("id", in.TaskId))
			return nil, err
		}
		return nil, nil
	}
	// 已被接手，删除关联关系
	alignments, err := l.svcCtx.OkrAlignmentModel.GetAlignWithEntityIdAndAlignID(l.ctx, okrTask.EntityId, int64(in.KeyresultId))
	if err != nil {
		logx.Errorw("获取关联关系失败", logx.Field("id", okrTask.EntityId))
		return nil, err
	}
	if len(alignments) == 0 {
		return &oa.EmptyResponse{}, nil
	}
	ids := []int64{}
	for _, alignment := range alignments {
		ids = append(ids, alignment.Id)
	}
	err = l.svcCtx.OkrAlignmentModel.DeleteByIds(ids)
	if err != nil {
		logx.Errorw("删除关联关系失败", logx.Field("err", err), logx.Field("ids", ids))
		return nil, err
	}

	return &oa.EmptyResponse{}, nil
}
