package okrrpclogic

import (
	"context"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateMessageStatusLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdateMessageStatusLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateMessageStatusLogic {
	return &UpdateMessageStatusLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *UpdateMessageStatusLogic) UpdateMessageStatus(in *oa.UpdateMessageStatusReq) (*oa.EmptyResponse, error) {
	// todo: add your logic here and delete this line
	message, err := l.svcCtx.OkrMsgModel.FindOne(l.ctx, in.MessageId)
	if err != nil {
		l.Logger.Errorw("failed to find message", logx.Field("error", err))
		return nil, ErrOkrMsgNotFound
	}
	if message.Type != OkrMessgeTypeAlignResp && message.Type != OkrMessgeTypeAssignResp && message.Type != OkrMessgeTypeAckResp { //必须是2,4,6才可以设置为我知道了
		return nil, ErrOkrMsgOperateFailed
	}
	if message.ToUser != in.UserEmail {
		return nil, ErrPermissionDenied
	}
	message.ApprovalStatus = in.Status
	err = l.svcCtx.OkrMsgModel.Update(l.ctx, message)
	if err != nil {
		l.Logger.Errorw("failed to update message status", logx.Field("error", err))
		return nil, ErrOkrMsgUpdateFailed
	}
	return &oa.EmptyResponse{}, nil
}
