package okrrpclogic

import (
	"context"
	"time"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateObjectiveLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdateObjectiveLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateObjectiveLogic {
	return &UpdateObjectiveLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *UpdateObjectiveLogic) UpdateObjective(in *oa.UpdateObjectiveReq) (*oa.UpdateObjectiveResp, error) {
	// todo: add your logic here and delete this line
	// 检查是否存在相同的时间段，如何将字符串日期转为time.time时间格式
	task, err := l.svcCtx.OkrTaskModel.FindOne(l.ctx, in.ObjectiveId)
	if err != nil {
		l.Logger.Errorw("failed to find objective", logx.Field("error", err))
		return nil, ErrOkrTaskNotFound
	}
	if task.Owner != in.UserEmail {
		return nil, ErrPermissionDenied
	}
	okrPeriod, err := l.svcCtx.OkrPeriodModel.FindOne(l.ctx, in.OkrId)
	if err != nil {
		l.Logger.Errorw("failed to find okr period", logx.Field("error", err))
		return nil, ErrOkrNotFound
	}
	if !isCreateOkr(okrPeriod.StartDate.Format(time.DateOnly)) {
		return nil, ErrOkrPeriodInvalid
	}
	if okrPeriod.Owner != in.UserEmail {
		return nil, ErrPermissionDenied
	}
	deadline, err := time.ParseInLocation(time.DateOnly, in.Deadline, time.Local)
	if err != nil {
		logx.Errorw("截止时间格式错误", logx.Field("err", err), logx.Field("deadline", in.Deadline))
		return nil, err
	}
	task.PeriodId = in.OkrId
	task.EntityId = in.ObjectiveId //主键，根据主键更新
	task.Content = in.Content
	task.Weight = in.Weight
	task.Priority = in.Priority
	task.Deadline = deadline
	err = l.svcCtx.OkrTaskModel.Update(l.ctx, task)
	if err != nil {
		l.Logger.Errorw("failed to update x_okr_task", logx.Field("error", err))
		return nil, ErrOkrTaskUpdateFailed
	}
	return &oa.UpdateObjectiveResp{}, nil
}
