package performancerpclogic

import (
	"context"
	"errors"

	"oa-server/app/oacenter/model/performance"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

type DeletePerformanceItemCommentLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDeletePerformanceItemCommentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeletePerformanceItemCommentLogic {
	return &DeletePerformanceItemCommentLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 删除评论
func (l *DeletePerformanceItemCommentLogic) DeletePerformanceItemComment(in *oa.DeletePerformanceItemCommentReq) (*oa.DeletePerformanceItemCommentResp, error) {
	p, err := l.svcCtx.PerformanceModel.XFindOne(l.ctx, in.GetPerformanceId())
	if err != nil {
		if errors.Is(err, performance.ErrNotFound) {
			return nil, ErrPerformanceNotFound
		}
		l.Logger.Errorw("failed to query x_performance on DeletePerformanceItemComment", logx.Field("error", err), logx.Field("performance_id", in.GetPerformanceId()))
		return nil, ErrPerformanceQueryFailed
	}
	// 绩效结束时不允许修改
	if p.Status == uint64(oa.PerformanceStatus_DONE) {
		return nil, ErrPerformanceCanNotBeModified
	}

	// 获取用户信息
	userDetail, err := l.svcCtx.LbkUcClient.GetLbkUserDetail(l.ctx, usercenter.LbkUserDetailReq{Email: p.UserEmail})
	if err != nil {
		logx.Errorw("failed to call usercenter.GetLbkUserDetail on DeletePerformanceItemComment", logx.Field("email", p.UserEmail), logx.Field("error", err))
		return nil, common.ErrUsercenterUnavailable
	}

	if p.UserEmail != in.GetUserEmail() && userDetail.LeaderEmail != in.GetUserEmail() {
		return nil, ErrPermissionDenied
	}

	pc, err := l.svcCtx.PerformanceItemCommentModel.XFindOne(l.ctx, in.GetCommentId())
	if err != nil {
		if errors.Is(err, performance.ErrNotFound) {
			return nil, ErrPerformanceItemCommentNotFound
		}
		l.Logger.Errorw("failed to query x_performance_item_comment on DeletePerformanceItemComment", logx.Field("error", err), logx.Field("comment_id", in.GetCommentId()))
		return nil, ErrPerformanceItemCommentQueryFailed
	}

	// 不是自己的评论不可删除
	if pc.UserEmail != in.GetUserEmail() {
		return nil, ErrPermissionDenied
	}

	if err = l.svcCtx.PerformanceItemCommentModel.XDelete(l.ctx, in.GetCommentId()); err != nil {
		l.Logger.Errorw("failed to delete x_performance_item_comment on DeletePerformanceItemComemnt", logx.Field("error", err),
			logx.Field("performance_id", in.GetPerformanceId()), logx.Field("comment_id", in.GetCommentId()))
		return nil, ErrPerformanceItemCommentDeleteFailed
	}

	return &oa.DeletePerformanceItemCommentResp{}, nil
}
