package performancerpclogic

import (
	"context"
	"google.golang.org/protobuf/types/known/timestamppb"
	"oa-server/app/oacenter/model/performance"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetPerformanceAdditionScoreListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetPerformanceAdditionScoreListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetPerformanceAdditionScoreListLogic {
	return &GetPerformanceAdditionScoreListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 环评列表
func (l *GetPerformanceAdditionScoreListLogic) GetPerformanceAdditionScoreList(in *oa.GetPerformanceAdditionScoreListReq) (*oa.GetPerformanceAdditionScoreListResp, error) {
	// todo: add your logic here and delete this line
	list, total, err := l.svcCtx.PerformanceAdditionScoreModel.PageByPerformanceAdditionScore(l.ctx, performance.PageByPerformanceAdditionScoreReq{
		Year:          in.GetYear(),
		UserEmail:     in.GetUserEmail(),
		MonthNum:      in.GetMonthNum(),
		CoworkerEmail: in.GetCoworkerEmail(),
		PageNum:       in.GetPageNum(),
		PageSize:      in.GetPageSize(),
		OrderBy:       in.GetOrderBy(),
	})
	if err != nil {
		l.Logger.Errorw("failed to query x_performance_addition_score on GetPerformanceAdditionScore", logx.Field("error", err))
		return nil, ErrPerformanceAdditionScoreFailed
	}
	items := make([]*oa.PerformanceAdditionScore, len(list))
	for i, v := range list {
		items[i] = &oa.PerformanceAdditionScore{
			Id:            v.Id,
			PerformanceId: v.PerformanceId,
			ItemId:        uint64(v.ItemId),
			Year:          v.Year,
			Score:         v.Score,
			MonthNum:      v.MonthNum,
			UserEmail:     v.UserEmail,
			Status:        uint64(v.Status),
			ItemDesc:      v.ItemDesc,
			CoworkerEmail: v.CoworkerEmail,
			CreatedAt:     timestamppb.New(v.CreatedAt),
			UpdatedAt:     timestamppb.New(v.UpdatedAt),
		}
	}
	return &oa.GetPerformanceAdditionScoreListResp{Total: total, List: items}, nil
}
