package performancerpclogic

import (
	"context"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

type GetPerformanceLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetPerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetPerformanceLogic {
	return &GetPerformanceLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 获取绩效
func (l *GetPerformanceLogic) GetPerformance(in *oa.GetPerformanceReq) (*oa.GetPerformanceResp, error) {
	if in.GetUserEmail() == "" || in.GetYear() == 0 {
		return nil, status.Error(codes.InvalidArgument, "无效的参数")
	}
	list, err := l.svcCtx.PerformanceModel.FindByUserAndTime(l.ctx, in.GetUserEmail(), in.GetYear(), in.GetMonthNum())
	if err != nil {
		l.Logger.Errorw("failed to query table x_perfromance on GetPerformance", logx.Field("error", err),
			logx.Field("user_email", in.GetUserEmail()), logx.Field("year", in.GetYear()), logx.Field("month_num", in.GetMonthNum()))
		return nil, ErrPerformanceQueryFailed
	}

	pList := make([]*oa.Performance, len(list))
	for i, p := range list {
		pList[i] = &oa.Performance{
			Id:                 p.Id,
			UserEmail:          p.UserEmail,
			Year:               p.Year,
			MonthNum:           p.MonthNum,
			WorkItemWeight:     p.WorkItemWeight,
			AdditionItemWeight: p.AdditionItemWeight,
			TotalScore:         p.TotalScore,
			LeaderWords:        p.LeaderWords,
			Status:             oa.PerformanceStatus(p.Status),
			CreatedAt:          timestamppb.New(p.CreatedAt),
			UpdatedAt:          timestamppb.New(p.UpdatedAt),
		}
	}

	return &oa.GetPerformanceResp{List: pList}, nil
}
