package performancerpclogic

import (
	"context"

	"oa-server/app/oacenter/model/performance"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/globalkey"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
	"google.golang.org/protobuf/types/known/timestamppb"
)

type GetStaffPerformanceListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetStaffPerformanceListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetStaffPerformanceListLogic {
	return &GetStaffPerformanceListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 获取直接下属绩效列表
func (l *GetStaffPerformanceListLogic) GetStaffPerformanceList(in *oa.GetStaffPerformanceListReq) (*oa.GetStaffPerformanceListResp, error) {
	if in.GetUserEmail() == "" || in.GetYear() == 0 {
		return nil, ErrInvalidParams
	}
	var err error
	var pList performance.PerformanceList
	var follower []*usercenter.PublicLbkUserOutside
	switch in.GetUserEmail() {
	case globalkey.RockyEmail:
		// Rocky要看研发部所有人的绩效
		follower, err = l.svcCtx.LbkUcClient.GetDepartmentDirectlyUser(l.ctx, usercenter.GetDepartmentDirectlyUserReq{
			AppKey:        l.svcCtx.Config.LbkUsercenter.AppName,
			AppToken:      l.svcCtx.Config.LbkUsercenter.AppToken,
			DepartmentKey: globalkey.RDDepartmentKey,
		})
		if err != nil {
			logx.Errorw("failed to call usercenter.GetDepartmentDirectlyUser on GetStaffPerformanceList", logx.Field("error", err))
			return nil, common.ErrUsercenterUnavailable
		}
	default:
		// 查询直接下属
		follower, err = l.svcCtx.LbkUcClient.GetLbkUserFollower(l.ctx, usercenter.LbkUserFllowerReq{Email: in.GetUserEmail()})
		if err != nil {
			l.Logger.Errorw("failed to call usercenter.GetLbkUserFollower on GetFollowerPerformanceList", logx.Field("error", err))
			return nil, common.ErrUsercenterUnavailable
		}
	}
	if len(follower) == 0 {
		return &oa.GetStaffPerformanceListResp{}, nil
	}

	req := performance.FindAllByUserAndTimeQuery{
		EmailList: getFollowerEmailList(follower),
		Year:      in.GetYear(),
		MonthNum:  in.GetMonthNum(),
	}
	pList, err = l.svcCtx.PerformanceModel.FindAllByUserAndTime(l.ctx, req)
	if err != nil {
		l.Logger.Errorw("failed to query x_performance on GetFollowerPerformanceList.FindAllByUserAndTime", logx.Field("error", err))
		return nil, ErrPerformanceQueryFailed
	}

	list := make([]*oa.Performance, len(pList))
	for i, p := range pList {
		list[i] = &oa.Performance{
			Id:                 p.Id,
			UserEmail:          p.UserEmail,
			Year:               p.Year,
			MonthNum:           p.MonthNum,
			WorkItemWeight:     p.WorkItemWeight,
			AdditionItemWeight: p.AdditionItemWeight,
			TotalScore:         p.TotalScore,
			Level:              p.Level,
			LeaderWords:        p.LeaderWords,
			Status:             oa.PerformanceStatus(p.Status),
			CreatedAt:          timestamppb.New(p.CreatedAt),
			UpdatedAt:          timestamppb.New(p.UpdatedAt),
		}
	}
	return &oa.GetStaffPerformanceListResp{List: list}, nil
}
