package performancerpclogic

import (
	"context"

	"github.com/zeromicro/go-zero/core/logx"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
)

type GetStaffPerformanceLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetStaffPerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetStaffPerformanceLogic {
	return &GetStaffPerformanceLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 获取员工绩效
func (l *GetStaffPerformanceLogic) GetStaffPerformance(in *oa.GetStaffPerformanceReq) (*oa.GetStaffPerformanceResp, error) {
	if in.GetStaffEmail() == "" || in.GetUserEmail() == "" || in.GetYear() == 0 {
		return nil, status.Error(codes.InvalidArgument, "无效参数")
	}

	// 鉴权
	//userResp, err := l.svcCtx.LbkUcClient.GetLbkUserDetail(l.ctx, usercenter.LbkUserDetailReq{Email: in.GetStaffEmail()})
	//if err != nil {
	//	l.Logger.Errorw("failed to call usercenter.GetLbkUserDetail on GetStaffPerformance", logx.Field("error", err))
	//	return nil, common.ErrUsercenterUnavailable
	//}

	// 只有直接上级、Rocky可以通过email来查询绩效
	//if userResp.LeaderEmail != in.GetUserEmail() && in.GetUserEmail() != globalkey.RockyEmail {
	//	return nil, ErrPermissionDenied
	//}

	list, err := l.svcCtx.PerformanceModel.FindByUserAndTime(l.ctx, in.GetStaffEmail(), in.GetYear(), in.GetMonthNum())
	if err != nil {
		l.Logger.Errorw("failed to query table x_perfromance on GetStaffPerformance", logx.Field("error", err),
			logx.Field("user_email", in.GetStaffEmail()), logx.Field("year", in.GetYear()), logx.Field("month_num", in.GetMonthNum()))
		return nil, ErrPerformanceQueryFailed
	}

	pList := make([]*oa.Performance, len(list))
	for i, p := range list {
		pList[i] = &oa.Performance{
			Id:                 p.Id,
			UserEmail:          p.UserEmail,
			Year:               p.Year,
			MonthNum:           p.MonthNum,
			WorkItemWeight:     p.WorkItemWeight,
			AdditionItemWeight: p.AdditionItemWeight,
			TotalScore:         p.TotalScore,
			LeaderWords:        p.LeaderWords,
			Status:             oa.PerformanceStatus(p.Status),
			CreatedAt:          timestamppb.New(p.CreatedAt),
			UpdatedAt:          timestamppb.New(p.UpdatedAt),
		}
	}

	return &oa.GetStaffPerformanceResp{List: pList}, nil
}
