package performancerpclogic

import (
	"context"
	"fmt"
	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"oa-server/app/oacenter/model/performance"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/msgcenter"

	"github.com/zeromicro/go-zero/core/logx"
)

type InformPerformanceLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewInformPerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *InformPerformanceLogic {
	return &InformPerformanceLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 通知下属
func (l *InformPerformanceLogic) InformPerformance(in *oa.InformPerformanceReq) (*oa.InformPerformanceResp, error) {
	// todo: add your logic here and delete this line
	larkUserList := in.LarkUserList
	for _, v := range larkUserList {
		// 获取用户信息
		userDetail, err := l.svcCtx.LbkUcClient.GetLbkUserDetail(l.ctx, usercenter.LbkUserDetailReq{Email: v.Email})
		if err != nil {
			logx.Errorw("failed to call usercenter.GetLbkUserDetail on FinishLeaderEvaluation", logx.Field("email", v.Email), logx.Field("error", err))
			return nil, common.ErrUsercenterUnavailable
		}
		content := ""
		switch v.Status {
		case uint64(oa.PerformanceStatus_WORKLOAD_FILLING):
			content = fmt.Sprintf("%s ，请及时完成绩效评估", extractEmailUsername(v.Email))
			l.sendLark(in.Year, in.MonthNum, content, v.Email, l.svcCtx.Config.Lark.MyPerformanceUrl)
		case uint64(oa.PerformanceStatus_LEADER_EVALUATION):
			content = fmt.Sprintf("%s ，请及时完成对 %s 的绩效评价", extractEmailUsername(userDetail.LeaderEmail), extractEmailUsername(v.Email))
			l.sendLark(in.Year, in.MonthNum, content, userDetail.LeaderEmail, l.svcCtx.Config.Lark.StaffPerformanceUrl)
		case uint64(oa.PerformanceStatus_NEED_STAFF_ACK):
			content = fmt.Sprintf("%s ，直属领导已打完绩效，请及时确认", extractEmailUsername(v.Email))
			l.sendLark(in.Year, in.MonthNum, content, v.Email, l.svcCtx.Config.Lark.MyPerformanceUrl)
		case uint64(oa.PerformanceStatus_NEED_LEADER_ACK):
			content = fmt.Sprintf("%s ，下属 %s 已确认绩效，请及时确认", extractEmailUsername(userDetail.LeaderEmail), extractEmailUsername(v.Email))
			l.sendLark(in.Year, in.MonthNum, content, userDetail.LeaderEmail, l.svcCtx.Config.Lark.StaffPerformanceUrl)
		case uint64(oa.PerformanceStatus_DONE):
			content = fmt.Sprintf("%s ，下属 %s 绩效评价已结束，请到绩效结果页及时提交", extractEmailUsername(userDetail.LeaderEmail), extractEmailUsername(v.Email))
			l.sendLark(in.Year, in.MonthNum, content, userDetail.LeaderEmail, l.svcCtx.Config.Lark.PerformanceResUrl)
		case uint64(oa.PerformanceStatus_COWORKER_EVALUATION):
			list, _, err := l.svcCtx.PerformanceAdditionScoreModel.ListPerformanceAdditionScore(l.ctx, performance.PageByPerformanceAdditionScoreReq{
				Year:      in.GetYear(),
				MonthNum:  in.GetMonthNum(),
				UserEmail: v.Email,
			})
			if err != nil {
				l.Logger.Errorw("failed to query x_performance_addition_score on GetPerformanceAdditionScore", logx.Field("error", err))
				return nil, ErrPerformanceAdditionScoreFailed
			}
			for _, item := range list {
				content = fmt.Sprintf("%s ，请及时完成对 %s 的绩效评价", extractEmailUsername(item.CoworkerEmail), extractEmailUsername(v.Email))
				l.sendLark(in.Year, in.MonthNum, content, item.CoworkerEmail, l.svcCtx.Config.Lark.ScorePerformanceUrl)
			}
		default:
			fmt.Println("其他")
		}
	}

	return &oa.InformPerformanceResp{}, nil
}
func (l *InformPerformanceLogic) sendLark(year, month_num uint64, content, receiveEmail, url string) {
	// 发送lark通知
	fmt.Println(year, month_num, receiveEmail, content, url)
	common.AsyncSendLarkMsg(l.svcCtx.Config.Env, func() {
		msgData := map[string]any{
			"title":      genPerformanceLarkMsgTitle(year, month_num),
			"content":    content,
			"target_url": url,
		}
		msg, err := l.svcCtx.LarkService.BuildCardContent(l.svcCtx.Config.Lark.PerformanceTmpId, msgData)
		if err != nil {
			l.Logger.Errorw("failed to build lark card content", logx.Field("error", err))
			return
		}
		if err = l.svcCtx.LarkService.SendCardMessage(msgcenter.LarkReceiveIdTypeEmail, receiveEmail, msgcenter.LarkMsgTypeCard, msg); err != nil {
			l.Logger.Errorw("failed to send user lark msg", logx.Field("error", err))
			return
		}
	})
}
