package performancerpclogic

import (
	"context"
	"fmt"
	"golang.org/x/time/rate"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/msgcenter"
	"oa-server/common/tool"

	"github.com/zeromicro/go-zero/core/logx"
)

type InformToWritePerformanceLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewInformToWritePerformanceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *InformToWritePerformanceLogic {
	return &InformToWritePerformanceLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

var InformToWritePerformanceLimiter = rate.NewLimiter(rate.Limit(10), 1)

// 提醒用户提交某段时间的绩效
func (l *InformToWritePerformanceLogic) InformToWritePerformance(in *oa.InformToWritePerformanceReq) (*oa.InformToWritePerformanceResp, error) {
	tool.GoSafe(func() {
		//today := time.Now().Local().Format(time.DateOnly)
		for _, user := range in.UserEmails {
			//listByDate, err := l.svcCtx.ReportModel.GetReportCountByUserAndDate(context.Background(), []string{user}, today, today)
			//if err != nil {
			//	logx.Errorw("[ReportAlertBot] failed to call ReportModel.GetReportCountByUserAndDate on CheckAndRemindTodayReport ", logx.Field("error", err), logx.Field("user", user))
			//	continue
			//}
			//if len(listByDate) == 0 {

			// 等待获取令牌，如果获取不到会阻塞
			err := InformToWritePerformanceLimiter.Wait(context.Background())
			if err != nil {
				l.Logger.Errorw("[ReportAlertBot] limiter wait error", logx.Field("error", err))
			}

			// 获取到令牌后
			if l.svcCtx.Config.Env == common.OA_RUNTIME_PROD_ENV { // 非生产环境不发消息
				//if true { // 非生产环境不发消息
				msg, err := l.svcCtx.LarkService.BuildCardContent(
					l.svcCtx.Config.Lark.GenericPlainTextTmpId,
					map[string]any{
						"title":           "绩效提醒",
						"body":            fmt.Sprintf("%s提醒您处理%d年%d月-%d月的绩效～", extractEmailUsername(in.SingedInUser), in.Year, in.MonthNum*2-1, in.MonthNum*2),
						"action_btn":      "现在处理",
						"action_btn_link": "https://oa.lbkwork.com/allPerformance/myPerformance",
					})
				if err != nil {
					l.Logger.Errorw("[ReportAlertBot] failed to build lark card content", logx.Field("error", err), logx.Field("user", user))
					continue
				}
				if err = l.svcCtx.LarkService.SendCardMessage(msgcenter.LarkReceiveIdTypeEmail, user, msgcenter.LarkMsgTypeCard, msg); err != nil {
					l.Logger.Errorw("[ReportAlertBot] failed to send user lark msg", logx.Field("error", err), logx.Field("user", user))
					continue
				}
			}
		}
		//}
	})

	return &oa.InformToWritePerformanceResp{}, nil
}
