package performancerpclogic

import (
	"context"
	"errors"

	"oa-server/app/oacenter/model/performance"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

type LeaderWordsLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewLeaderWordsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *LeaderWordsLogic {
	return &LeaderWordsLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 上级评价
func (l *LeaderWordsLogic) LeaderWords(in *oa.LeaderWordsReq) (*oa.LeaderWordsResp, error) {
	p, err := l.svcCtx.PerformanceModel.XFindOne(l.ctx, in.GetPerformanceId())
	if err != nil {
		l.Logger.Errorw("failed to query talbe x_performance on LeaderWords", logx.Field("error", err), logx.Field("id", in.GetPerformanceId()))
		if errors.Is(err, performance.ErrNotFound) {
			return nil, ErrPerformanceNotFound
		}
		return nil, ErrPerformanceQueryFailed
	}

	// 查询绩效归属人信息
	user, err := l.svcCtx.LbkUcClient.GetLbkUserDetail(l.ctx, usercenter.LbkUserDetailReq{Email: p.UserEmail})
	if err != nil {
		logx.Errorw("failed to call usercenter.GetLbkUserDetail on LeaderWords", logx.Field("error", err))
		return nil, common.ErrUsercenterUnavailable
	}

	if user.LeaderEmail != in.GetUserEmail() {
		return nil, ErrPermissionDenied
	}
	if p.Status == uint64(oa.PerformanceStatus_DONE) {
		return nil, ErrPerformanceCanNotBeModified
	}

	p.LeaderWords = in.GetLeaderWords()
	if err = l.svcCtx.PerformanceModel.XUpdate(l.ctx, p); err != nil {
		l.Logger.Errorw("failed to update table x_performance on LeaderWords", logx.Field("id", p.Id), logx.Field("error", err))
		return nil, ErrPerformanceUpdateFailed
	}

	return &oa.LeaderWordsResp{}, nil
}
