package performancerpclogic

import (
	"context"
	"errors"
	"github.com/shopspring/decimal"

	"github.com/zeromicro/go-zero/core/logx"
	"oa-server/app/oacenter/model/performance"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
)

type PerformanceSelfAckLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewPerformanceSelfAckLogic(ctx context.Context, svcCtx *svc.ServiceContext) *PerformanceSelfAckLogic {
	return &PerformanceSelfAckLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 员工自己确认绩效
func (l *PerformanceSelfAckLogic) PerformanceSelfAck(in *oa.PerformanceSelfAckReq) (*oa.PerformanceSelfAckResp, error) {
	p, err := l.svcCtx.PerformanceModel.XFindOne(l.ctx, in.GetPerformanceId())
	if err != nil {
		l.Logger.Errorw("failed to query table x_performance on PerformanceSelfAck", logx.Field("error", err), logx.Field("id", in.GetPerformanceId()))
		if errors.Is(err, performance.ErrNotFound) {
			return nil, ErrPerformanceNotFound
		}
		return nil, ErrPerformanceQueryFailed
	}

	if p.UserEmail != in.GetUserEmail() {
		return nil, ErrPermissionDenied
	}
	if p.Status == uint64(oa.PerformanceStatus_DONE) {
		return nil, ErrPerformanceCanNotBeModified
	}

	if p.Status == uint64(oa.PerformanceStatus_NEED_STAFF_ACK) {
		p.Status = uint64(oa.PerformanceStatus_DONE)
		totalBonus, _ := decimal.NewFromFloat(p.TimeFactor).
			Mul(decimal.NewFromInt(bonusMonthBase)).
			Mul(decimal.NewFromFloat(p.LevelFactor)).
			Sub(decimal.NewFromFloat(p.IncidentDeduction)).
			Add(decimal.NewFromFloat(p.ExcellentMemberBonus)).
			Add(decimal.NewFromFloat(p.ExcellentManagerBonus)).Round(2).Float64()
		// 更新total_bonus
		p.TotalBonus = totalBonus
		if err = l.svcCtx.PerformanceModel.XUpdate(l.ctx, p); err != nil {
			l.Logger.Errorw("failed to update table x_performance on PerformanceSelfAck", logx.Field("error", err), logx.Field("id", p.Id))
			return nil, ErrPerformanceUpdateFailed
		}

	}

	// 发送lark通知
	//common.AsyncSendLarkMsg(l.svcCtx.Config.Env, func() {
	//	msgData := map[string]any{
	//		"title":      genPerformanceLarkMsgTitle(p.Year, p.MonthNum),
	//		"content":    fmt.Sprintf("%s 已确认绩效结果，请知晓", extractEmailUsername(p.UserEmail)),
	//		"target_url": l.svcCtx.Config.Lark.StaffPerformanceUrl,
	//	}
	//	msg, err := l.svcCtx.LarkService.BuildCardContent(l.svcCtx.Config.Lark.PerformanceTmpId, msgData)
	//	if err != nil {
	//		l.Logger.Errorw("failed to build lark card content", logx.Field("error", err))
	//		return
	//	}
	//	if err = l.svcCtx.LarkService.SendCardMessage(msgcenter.LarkReceiveIdTypeEmail, p.LeaderEmail, msgcenter.LarkMsgTypeCard, msg); err != nil {
	//		l.Logger.Errorw("failed to send user lark msg", logx.Field("error", err))
	//		return
	//	}
	//})

	return &oa.PerformanceSelfAckResp{}, nil
}
