package performancerpclogic

import (
	"context"
	"fmt"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/msgcenter"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/stores/sqlx"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceAdditionScoreLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdatePerformanceAdditionScoreLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceAdditionScoreLogic {
	return &UpdatePerformanceAdditionScoreLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 评价
func (l *UpdatePerformanceAdditionScoreLogic) UpdatePerformanceAdditionScore(in *oa.UpdatePerformanceAdditionScoreReq) (*oa.UpdatePerformanceAdditionScoreResp, error) {
	// todo: add your logic here and delete this line
	performanceAdditioninfo, err := l.svcCtx.PerformanceAddtionModel.XFindOne(l.ctx, in.GetItemId()) // xfind
	if err != nil {
		l.Logger.Errorw("failed to query table x_performance_addition on UpdatePerformanceAdditionItem", logx.Field("id", in.GetItemId()), logx.Field("error", err))
		return nil, ErrPerformanceAdditionItemQueryFailed
	}
	if in.GetUserEmail() != performanceAdditioninfo.CoworkerEmail {
		l.Logger.Errorw("userEmail is not match", logx.Field("userEmail", in.GetUserEmail()), logx.Field("performanceAdditioninfo.UserEmail", performanceAdditioninfo.CoworkerEmail))
		return nil, ErrPermissionDenied
	}
	performanceinfo, err := l.svcCtx.PerformanceModel.XFindOne(l.ctx, performanceAdditioninfo.PerformanceId) //xfind
	if err != nil {
		l.Logger.Errorw("failed to query table x_performance", logx.Field("id", performanceAdditioninfo.PerformanceId), logx.Field("error", err))
		return nil, ErrPerformanceQueryFailed
	}
	if performanceinfo.Status == uint64(oa.PerformanceStatus_COWORKER_EVALUATION) {
		performanceinfo.Status = uint64(oa.PerformanceStatus_LEADER_EVALUATION)
	} else {
		return nil, ErrPermissionDenied
	}

	// 查询绩效归属人信息
	user, err := l.svcCtx.LbkUcClient.GetLbkUserDetail(l.ctx, usercenter.LbkUserDetailReq{Email: performanceinfo.UserEmail})
	if err != nil {
		logx.Errorw("failed to call usercenter.GetLbkUserDetail on UpdatePerformanceAdditionScore", logx.Field("error", err))
		return nil, common.ErrUsercenterUnavailable
	}

	performanceAdditionScoreinfo, err := l.svcCtx.PerformanceAdditionScoreModel.XFindOne(l.ctx, in.GetItemId()) //xfind
	if err != nil {
		l.Logger.Errorw("failed to query table x_performance_addition_score", logx.Field("id", in.GetItemId()), logx.Field("error", err))
	}
	//判断 ruguo status=2    2 表示已评价  zhijie return
	if performanceAdditionScoreinfo.Status == 2 {
		return nil, ErrPerformanceAdditionScoreAlreadyEvaluated
	}
	performanceAdditionScoreinfo.ItemDesc = in.GetItemDesc()
	performanceAdditionScoreinfo.Score = in.GetScore()
	performanceAdditionScoreinfo.Status = 2

	performanceAdditioninfo.ItemDesc = in.GetItemDesc() //更新addition
	performanceAdditioninfo.SelfScore = in.GetScore()   //更新addition
	//放在事务中
	err = l.svcCtx.PerformanceModel.TransCtx(l.ctx, func(ctx context.Context, session sqlx.Session) error {
		//更新addition_score
		if err := l.svcCtx.PerformanceAdditionScoreModel.TransUpdateCtx(ctx, session, performanceAdditionScoreinfo); err != nil {
			l.Logger.Errorw("failed to update x_performance_addition_score itemDesc and Score", logx.Field("error", err), logx.Field("item_id", in.GetItemId()))
			return ErrPerformanceAdditionScoreFailed
		}
		//更新addition
		if err := l.svcCtx.PerformanceAddtionModel.TransUpdateCtx(ctx, session, performanceAdditioninfo); err != nil {
			l.Logger.Errorw("failed to update x_performance_addition_score itemDesc and Score", logx.Field("error", err), logx.Field("item_id", in.GetItemId()))
			return ErrPerformanceAdditionItemUpdateFailed
		}
		//更新performance
		if err := l.svcCtx.PerformanceModel.TransUpdateCtx(ctx, session, performanceinfo); err != nil {
			l.Logger.Errorw("failed to update x_performance status", logx.Field("error", err), logx.Field("performance_id", performanceinfo.Id))
			return ErrPerformanceUpdateFailed
		}

		return nil
	})
	if err != nil {
		l.Logger.Errorw("failed to update x_performance_addition_score itemDesc and Score", logx.Field("error", err), logx.Field("item_id", in.GetItemId()))
		return nil, ErrPerformanceAdditionScoreFailed
	}
	//发送lark通知
	common.AsyncSendLarkMsg(l.svcCtx.Config.Env, func() {
		msgData := map[string]any{
			"title":      genPerformanceLarkMsgTitle(performanceinfo.Year, performanceinfo.MonthNum),
			"content":    fmt.Sprintf("%s 已完成绩效评估，请及时确认", extractEmailUsername(performanceinfo.UserEmail)),
			"target_url": l.svcCtx.Config.Lark.ScorePerformanceUrl,
		}
		msg, err := l.svcCtx.LarkService.BuildCardContent(l.svcCtx.Config.Lark.PerformanceTmpId, msgData)
		if err != nil {
			l.Logger.Errorw("failed to build lark card content", logx.Field("error", err))
			return
		}
		if err = l.svcCtx.LarkService.SendCardMessage(msgcenter.LarkReceiveIdTypeEmail, user.LeaderEmail, msgcenter.LarkMsgTypeCard, msg); err != nil {
			l.Logger.Errorw("failed to send user lark msg", logx.Field("error", err))
			return
		}
	})
	return &oa.UpdatePerformanceAdditionScoreResp{}, nil
}
