package performancerpclogic

import (
	"context"
	"errors"

	"oa-server/app/oacenter/model/performance"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceItemCommentLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdatePerformanceItemCommentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceItemCommentLogic {
	return &UpdatePerformanceItemCommentLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 更新评论
func (l *UpdatePerformanceItemCommentLogic) UpdatePerformanceItemComment(in *oa.UpdatePerformanceItemCommentReq) (*oa.UpdatePerformanceItemCommentResp, error) {
	p, err := l.svcCtx.PerformanceModel.XFindOne(l.ctx, in.GetPerformanceId())
	if err != nil {
		if errors.Is(err, performance.ErrNotFound) {
			return nil, ErrPerformanceNotFound
		}
		l.Logger.Errorw("failed to query x_performance on UpdatePerformanceItemComment", logx.Field("error", err), logx.Field("performance_id", in.GetPerformanceId()))
		return nil, ErrPerformanceQueryFailed
	}
	// 绩效结束时不允许修改
	if p.Status == uint64(oa.PerformanceStatus_DONE) {
		return nil, ErrPerformanceCanNotBeModified
	}

	// 查询绩效归属人信息
	user, err := l.svcCtx.LbkUcClient.GetLbkUserDetail(l.ctx, usercenter.LbkUserDetailReq{Email: p.UserEmail})
	if err != nil {
		logx.Errorw("failed to call usercenter.GetLbkUserDetail on UpdatePerformanceItemComment", logx.Field("error", err))
		return nil, common.ErrUsercenterUnavailable
	}
	// 绩效评论只有自己和上级可以修改
	if p.UserEmail != in.GetUserEmail() && user.LeaderEmail != in.GetUserEmail() {
		return nil, ErrPermissionDenied
	}

	pc, err := l.svcCtx.PerformanceItemCommentModel.XFindOne(l.ctx, in.GetCommentId())
	if err != nil {
		if errors.Is(err, performance.ErrNotFound) {
			return nil, ErrPerformanceItemCommentNotFound
		}
		l.Logger.Errorw("failed to query x_performance_item_comment on UpdatePerformanceItemComment", logx.Field("error", err), logx.Field("comment_id", in.GetCommentId()))
		return nil, ErrPerformanceItemCommentQueryFailed
	}
	// 不是自己的评论不可更新
	if pc.UserEmail != in.GetUserEmail() {
		return nil, ErrPermissionDenied
	}

	pc.Comment = in.GetComment()
	if err = l.svcCtx.PerformanceItemCommentModel.XUpdate(l.ctx, pc); err != nil {
		l.Logger.Errorw("failed to update x_performance_item_comment on UpdatePerformanceItemComment", logx.Field("error", err), logx.Field("comment_id", in.GetCommentId()))
		return nil, ErrPerformanceItemCommentUpdateFailed
	}

	return &oa.UpdatePerformanceItemCommentResp{}, nil
}
