package performancerpclogic

import (
	"context"
	"errors"
	"oa-server/app/oacenter/model/performance"
	"oa-server/app/oacenter/oa_rpc/internal/logic/common"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/globalkey"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

type UpdatePerformanceStatusUpdateLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdatePerformanceStatusUpdateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdatePerformanceStatusUpdateLogic {
	return &UpdatePerformanceStatusUpdateLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 更新绩效状态
func (l *UpdatePerformanceStatusUpdateLogic) UpdatePerformanceStatusUpdate(in *oa.UpdatePerformanceStatusUpdateReq) (*oa.UpdatePerformanceStatusUpdateResp, error) {
	// todo: add your logic here and delete this line
	pList, err := l.svcCtx.PerformanceModel.XFindOneByIds(l.ctx, in.GetPerformanceId())
	if err != nil {
		if errors.Is(err, performance.ErrNotFound) {
			return nil, ErrPerformanceNotFound
		}
		l.Logger.Errorw("failed to query x_performnace on UpdatePerformanceBonus", logx.Field("error", err))
		return nil, ErrPerformanceQueryFailed
	}

	// 查询所有人信息
	userList, err := l.svcCtx.LbkUcClient.GetAllUser(l.ctx)
	if err != nil {
		logx.Errorw("failed to call usercenter.GetAllUser on UpdatePerformanceStatusUpdate", logx.Field("error", err))
		return nil, common.ErrUsercenterUnavailable
	}
	userMap := make(map[string]*usercenter.PublicLbkUserOutside, len(userList))
	for _, u := range userList {
		userMap[u.Email] = u
	}

	for _, p := range pList {
		user, ok := userMap[p.UserEmail]
		if !ok || user == nil {
			logx.Infow("用户不存在", logx.Field("user_email", p.UserEmail))
			continue
		}

		if user.LeaderEmail != in.GetUserEmail() && in.GetUserEmail() != globalkey.RockyEmail {
			return nil, ErrPermissionDenied
		}
		if in.Status == uint64(oa.PerformanceStatus_NEED_CONFIRM) { //如果要改为待确认状态，之前的状态必须是待提交状态
			if p.Status != uint64(oa.PerformanceStatus_DONE) {
				continue //如果不是待提交，直接跳过，处理下一个绩效
			}
		}
		if in.Status == uint64(oa.PerformanceStatus_SUBMITTED) { //如果要改为已确认状态，之前的状态必须是待确认状态
			if p.Status != uint64(oa.PerformanceStatus_NEED_CONFIRM) {
				continue //如果不是待确定，直接跳过，处理下一个绩效
			}
		}
		if in.Status == uint64(oa.PerformanceStatus_DONE) { //如果要改为待提交状态，之前的状态必须是待确认状态（点击建议修改）
			if p.Status != uint64(oa.PerformanceStatus_NEED_CONFIRM) {
				continue //如果不是待确认状态，直接跳过，处理下一个绩效
			}
		}
		data := performance.UpdatePerformanceStatusQuery{
			PerformanceID: p.Id,
			Status:        in.Status,
		}
		if err = l.svcCtx.PerformanceModel.UpdatePerformanceStatus(l.ctx, data); err != nil {
			l.Logger.Errorw("failed to update x_performance on UpdatePerformanceBonus", logx.Field("error", err))
			return nil, ErrPerformanceUpdateFailed
		}
	}
	return &oa.UpdatePerformanceStatusUpdateResp{}, nil
}
