package reportrpclogic

import (
	"oa-server/app/oacenter/oa_rpc/oa"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

const (
	ReportMaxPageSize     = 100
	ReportDefaultPageSize = 10

	ReportCommentMaxCount = 5
)

var (
	ErrUserEmailRequired = status.Error(codes.InvalidArgument, "user_email参数必填")
	ErrReportIdRequired  = status.Error(codes.InvalidArgument, "report_id参数必填")

	// 工作汇报
	ErrReportExists       = status.Error(codes.AlreadyExists, "工作汇报已存在")
	ErrReportNotFound     = status.Error(codes.NotFound, "工作汇报未找到")
	ErrReportQueryFailed  = status.Error(codes.Internal, "查询工作汇报失败")
	ErrReportUpdateFailed = status.Error(codes.Internal, "更新工作汇报失败")
	ErrReportCreateFailed = status.Error(codes.Internal, "创建工作汇报失败")

	// 工作汇报项
	ErrReportItemQueryFailed = status.Error(codes.Internal, "查询工作汇报项失败")

	// 工作汇报评论
	ErrReportCommentCreateFailed = status.Error(codes.Internal, "创建工作汇报评论失败")
	ErrReportCommentQueryFailed  = status.Error(codes.Internal, "查询工作汇报评论失败")

	// 工作汇报提及
	ErrReportMentionQueryFailed = status.Error(codes.Internal, "查询工作汇报提及失败")
)

func convertReportStatus(isDraft bool) oa.ReportStatus {
	if isDraft {
		return oa.ReportStatus_DRAFT_RS
	}
	return oa.ReportStatus_DONE_RS
}

// true: 1, false: 0
func convertBoolToInt64(b bool) int64 {
	if b {
		return 1
	}
	return 0
}

// 0: false, 1: true
func convertIn64ToBool(n int64) bool {
	return n == 1
}
