package userrpclogic

import (
	"context"
	"oa-server/app/jobcenter/model"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type DepartmentListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDepartmentListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DepartmentListLogic {
	return &DepartmentListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

// 获取部门列表
func (l *DepartmentListLogic) DepartmentList(in *oa.DepartmentListReq) (*oa.DepartmentListResp, error) {

	cache := model.NewUserCenterService(l.svcCtx.RedisClient)

	userInfo, err := cache.GetUserByEmail(l.ctx, in.Employee)
	if err != nil {
		return nil, err
	}
	dptList, err := cache.GetAllDepartments(l.ctx)
	if err != nil {
		return nil, err
	}
	resp := &oa.DepartmentListResp{
		List: []*oa.DepartmentInfo{},
	}
	validList := []model.DepartmentInfo{}
	if in.Valid {
		for _, dpt := range dptList {
			if dpt.DepartmentKey == userInfo.SecondDepartmentList[0].DepartmentKey ||
				dpt.ParentDepartmentKey == userInfo.SecondDepartmentList[0].DepartmentKey {
				validList = append(validList, dpt)
			}
		}

	} else {
		validList = dptList
	}

	resp.Total = int64(len(validList))
	resp.List = make([]*oa.DepartmentInfo, len(validList))
	for i, dpt := range validList {
		resp.List[i] = &oa.DepartmentInfo{
			Key:    dpt.DepartmentKey,
			Name:   dpt.DepartmentName,
			Leader: dpt.Owner,
		}
	}
	return resp, nil
}
