package userrpclogic

import (
	"context"

	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"

	"github.com/zeromicro/go-zero/core/logx"
)

type DepartmentLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDepartmentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DepartmentLogic {
	return &DepartmentLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *DepartmentLogic) Department(in *oa.DepartmentReq) (*oa.DepartmentListResp, error) {

	switch in.Type {
	case "parent":
		department, err := l.svcCtx.UserCache.GetParentDepartmentByKey(l.ctx, in.DepartmentKey)
		if err != nil {
			return nil, err
		}
		return &oa.DepartmentListResp{
			List: []*oa.DepartmentInfo{
				{
					Key:    department.DepartmentKey,
					Name:   department.DepartmentName,
					Leader: department.Owner,
				},
			},
			Total: 1,
		}, nil
	}

	return &oa.DepartmentListResp{}, nil
}
