package userrpclogic

import (
	"context"

	"oa-server/app/jobcenter/model"
	"oa-server/app/oacenter/oa_rpc/internal/svc"
	"oa-server/app/oacenter/oa_rpc/oa"
	"oa-server/common/globalkey"

	"github.com/zeromicro/go-zero/core/logx"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

type GetUserFollowerLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetUserFollowerLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetUserFollowerLogic {
	return &GetUserFollowerLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *GetUserFollowerLogic) GetUserFollower(in *oa.GetUserFollowerReq) (*oa.GetUserFollowerResp, error) {
	userEmail := in.GetUserEmail()
	cache := model.NewUserCenterService(l.svcCtx.RedisClient)
	users, err := cache.GetAllUsers(l.ctx)
	if err != nil {
		l.Logger.Infow("failed to get user list from cache", logx.Field("error", err))
	}

	if len(users) == 0 {
		// 未从缓存中获取到，去用户中心查研发部所有人员
		userList, err := l.svcCtx.LbkUcClient.GetAllUser(l.ctx)
		if err != nil {
			l.Logger.Errorw("failed to call usercenter.GetDepartmentUser on GetUserFolloer", logx.Field("error", err))
			return nil, status.Error(codes.Unavailable, "用户中心服务暂不可用")
		}

		users = make([]model.UserInfo, len(userList))
		for i, u := range userList {
			dpList := make([]model.Dept, len(u.DepartmentList))
			for j, d := range u.DepartmentList {
				dpList[j] = model.Dept{
					DepartmentName: d.DepartmentName,
					DepartmentKey:  d.DepartmentKey,
				}
			}
			ownDpList := make([]model.Dept, len(u.OwnerDepartmentList))
			for j, d := range u.OwnerDepartmentList {
				ownDpList[j] = model.Dept{
					DepartmentName: d.DepartmentName,
					DepartmentKey:  d.DepartmentKey,
				}
			}
			secondDpList := make([]model.Dept, len(u.SecondDepartmentList))
			for j, d := range u.SecondDepartmentList {
				secondDpList[j] = model.Dept{
					DepartmentName: d.DepartmentName,
					DepartmentKey:  d.DepartmentKey,
				}
			}

			users[i] = model.UserInfo{
				ID:                   int64(u.ID),
				Username:             u.UserName,
				NickName:             u.NickName,
				LarkHeaderImg:        u.LarkHeaderImg,
				Email:                u.Email,
				LeaderEmail:          u.LeaderEmail,
				JobName:              u.JobName,
				JobKey:               u.JobKey,
				DepartmentKeyList:    u.DepartmentKeyList,
				DepartmentList:       dpList,
				Creator:              u.Creator,
				CreatedAtStr:         u.CreatedAtStr,
				Enable:               u.Enable,
				OwnerDepartmentList:  ownDpList,
				SecondDepartmentList: secondDpList,
			}
		}
	}

	// 当前用户的直接下属
	var followers []*oa.UserInfo

	// 研发部所有用户
	var list []*oa.UserInfo
	for _, u := range users {
		// 离职员工直接跳过
		if u.UserStatus == globalkey.UserStatusResign {
			continue
		}
		dpList := make([]*oa.DepartmentInfo, len(u.DepartmentList))
		for j, d := range u.DepartmentList {
			dpList[j] = &oa.DepartmentInfo{
				Name: d.DepartmentName,
				Key:  d.DepartmentKey,
			}
		}
		v := &oa.UserInfo{
			Id:              u.ID,
			Nickname:        u.NickName,
			Email:           u.Email,
			LarkHeaderImage: u.LarkHeaderImg,
			Departments:     dpList,
			UserStatus:      int32(u.UserStatus),
		}
		list = append(list, v)

		// 获取当前用户的直接下属
		if u.LeaderEmail == userEmail {
			followers = append(followers, v)
		}
	}

	if userEmail == globalkey.RockyEmail {
		// rocky可以看研发部门所有用户
		return &oa.GetUserFollowerResp{Total: uint64(len(list)), List: list}, nil
	}

	return &oa.GetUserFollowerResp{Total: uint64(len(followers)), List: followers}, nil
}
