package handler

import (
	"net/http"

	"oa-server/app/usercenter/api/internal/logic"
	"oa-server/app/usercenter/api/internal/svc"
	"oa-server/response"
)

// 获取用户下属员工
func GetUserFollowersHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		l := logic.NewGetUserFollowersLogic(r.Context(), svcCtx)
		resp, err := l.GetUserFollowers()
		if err != nil {
			response.Error(w, err)
			return
		}
		response.Success(w, resp.UserList)
	}
}
