package logic

import (
	"context"

	"oa-server/app/usercenter/api/internal/svc"
	"oa-server/app/usercenter/api/internal/types"
	"oa-server/common/ctxdata"

	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
)

type GetUserFollowersLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取用户下属员工
func NewGetUserFollowersLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetUserFollowersLogic {
	return &GetUserFollowersLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetUserFollowersLogic) GetUserFollowers() (resp *types.GetUserFollowersResp, err error) {
	email := l.ctx.Value(ctxdata.CtxKeyJwtUserEmail).(string)
	userList, err := l.svcCtx.LbkUcClient.GetLbkUserFollower(l.ctx, usercenter.LbkUserFllowerReq{Email: email})
	if err != nil {
		l.Logger.Errorw("failed to call usercenter.GetLbkUserFollower", logx.Field("error", err))
		return nil, err
	}

	users := make([]types.User, len(userList))
	for i, v := range userList {
		users[i] = types.User{
			Email:       v.Email,
			Username:    v.UserName,
			Nickname:    v.NickName,
			Avator:      v.LarkHeaderImg,
			LeaderEmail: v.LeaderEmail,
		}
	}

	return &types.GetUserFollowersResp{UserList: users}, nil
}
