package logic

import (
	"context"

	"oa-server/app/usercenter/api/internal/svc"
	"oa-server/app/usercenter/api/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetUserListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取用户列表
func NewGetUserListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetUserListLogic {
	return &GetUserListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetUserListLogic) GetUserList(req *types.GetUserListReq) (resp *types.GetUserListResp, err error) {
	userListResp, err := l.svcCtx.LbkUcClient.GetAllUser(l.ctx)
	if err != nil {
		l.Logger.Errorw("failed to call usercenter.GetUserList", logx.Field("error", err))
		return nil, err
	}

	var users []types.User
	for _, u := range userListResp {
		users = append(users, types.User{
			Nickname: u.NickName,
			Username: u.UserName,
			Email:    u.Email,
			Enable:   u.Enable,
		})
	}

	return &types.GetUserListResp{Total: int64(len(users)), UserList: users}, nil
}
