package svc

import (
	"oa-server/app/usercenter/api/internal/config"
	"oa-server/app/usercenter/rpc/usercenterclient"
	"oa-server/common/middleware"

	"github.com/zeromicro/go-zero/rest"
	"github.com/zeromicro/go-zero/zrpc"

	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"
)

type ServiceContext struct {
	Config         config.Config
	AuthMiddleware rest.Middleware
	UsercenterRpc  usercenterclient.Usercenter
	LbkUcClient    *lbkUc.LbkUserClient
}

func NewServiceContext(c config.Config) *ServiceContext {
	// 初始化用户中心client
	lbkUcClient, _ := lbkUc.NewLbkUserClient(c.LbkUsercenter.Env, c.LbkUsercenter.HostInAli)

	return &ServiceContext{
		Config:         c,
		AuthMiddleware: middleware.NewAuthMiddleware(c.LbkUsercenter.AppName, lbkUcClient).Handle,
		UsercenterRpc:  usercenterclient.NewUsercenter(zrpc.MustNewClient(c.UsercenterRpcConf)),
		LbkUcClient:    lbkUcClient,
	}
}
