package model

import "github.com/zeromicro/go-zero/core/stores/sqlx"

var _ SysUsersModel = (*customSysUsersModel)(nil)

type (
	// SysUsersModel is an interface to be customized, add more methods here,
	// and implement the added methods in customSysUsersModel.
	SysUsersModel interface {
		sysUsersModel
		withSession(session sqlx.Session) SysUsersModel
	}

	customSysUsersModel struct {
		*defaultSysUsersModel
	}
)

// NewSysUsersModel returns a model for the database table.
func NewSysUsersModel(conn sqlx.SqlConn) SysUsersModel {
	return &customSysUsersModel{
		defaultSysUsersModel: newSysUsersModel(conn),
	}
}

func (m *customSysUsersModel) withSession(session sqlx.Session) SysUsersModel {
	return NewSysUsersModel(sqlx.NewSqlConnFromSession(session))
}
